% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDelaunay}
\alias{plotDelaunay}
\title{Plot 2D Delaunay triangulation}
\usage{
plotDelaunay(
  del,
  col_edges = "black",
  col_borders = "red",
  color = "distinct",
  hue = "random",
  luminosity = "light",
  lty_edges = par("lty"),
  lwd_edges = par("lwd"),
  lty_borders = par("lty"),
  lwd_borders = par("lwd"),
  ...
)
}
\arguments{
\item{del}{an output of \code{\link{delaunay}} without constraints 
(\code{edges=NULL}) or with constraints}

\item{col_edges}{the color of the edges of the triangles; \code{NULL} for
no edges}

\item{col_borders}{the color of the border edges for a constrained 
Delaunay tessellation; \code{NULL} for no border edges}

\item{color}{controls the filling colors of the triangles, either
\code{FALSE} for no color, a single color, \code{"random"} to get multiple 
colors with \code{\link[randomcoloR]{randomColor}}, or \code{"distinct"} 
get multiple colors with \code{\link[randomcoloR]{distinctColorPalette}}}

\item{hue, luminosity}{if \code{color = "random"}, these arguments are passed
to \code{\link[randomcoloR]{randomColor}}}

\item{lty_edges, lwd_edges}{graphical parameters for the edges of the triangles}

\item{lty_borders, lwd_borders}{graphical parameters for the border edges in 
the case of a constrained Delaunay tessellation}

\item{...}{arguments passed to \code{\link{plot}} for the vertices}
}
\value{
No value, just renders a 2D plot.
}
\description{
Plot a constrained 2D Delaunay triangulation.
}
\examples{
# random points in a square
set.seed(314)
library(RCDT)
library(uniformly)
square <- rbind(
  c(-1, 1), c(1, 1), c(1, -1), c(-1, -1)
)
ptsin <- runif_in_cube(10L, d = 2L)
pts <- rbind(square, ptsin)
d <- delaunay(pts)
opar <- par(mar = c(0, 0, 0, 0))
plotDelaunay(
  d, xlab = NA, ylab = NA, asp = 1, color = "random", luminosity = "dark"
)
par(opar)
}
