% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/UserMetrics.R
\name{user_Metrics_Clicks}
\alias{user_Metrics_Clicks}
\title{Returns the aggregate number of clicks on all of the authenticated user's Bitlinks.}
\usage{
user_Metrics_Clicks(limit = 1000, unit = c("minute", "hour", "day", "week",
  "month"), units = -1, rollup = c("false", "true"),
  showRequestURL = FALSE)
}
\arguments{
\item{limit}{- 1 to 1000 (default=1000).}

\item{unit}{- minute, hour, day, week or month, default: day; Note: when unit is minute the maximum
value for units is 60.}

\item{units}{- an integer representing the time units to query data for. Pass -1 to return all
units of time.}

\item{rollup}{- true or false. Return data for multiple units rolled up to a single result instead
of a separate value for each period of time.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
dt - a unix timestamp representing the beginning of this unit.

day_start - a unix timestamp representing the beginning of the specified day (ONLY returned
if unit is not specified).

clicks - the number of clicks on this user's links in the specified timeframe.
}
\description{
Returns the aggregate number of clicks on all of the authenticated user's Bitlinks.
}
\note{
without the parameter unit this endpoint returns a legacy response format which assumes
rollup=false, unit=day and units=7.
}
\examples{
options(Bit.ly = "0906523ec6a8c78b33f9310e84e7a5c81e500909")
user_Metrics_Clicks(unit = "day", units = -1, limit = 100, rollup = "true")
user_Metrics_Clicks(unit = "day", units = -1, limit = 100, rollup = "false")
}
\seealso{
See \url{http://dev.bitly.com/user_metrics.html#v3_user_clicks}
}

