% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc1Sdecision.R
\name{oc1Sdecision}
\alias{oc1Sdecision}
\title{Decision Function for 1 Sample Operating Characteristics}
\usage{
oc1Sdecision(pc = 0.975, qc = 0, lower.tail = TRUE)
}
\arguments{
\item{pc}{vector of critical cumulative probabilities of the
difference distribution.}

\item{qc}{vector of respective critical values of the difference
distribution. Must match the length of \code{pc}.}

\item{lower.tail}{logical value selecting if the threshold is a
lower or upper bound.}
}
\description{
The function sets up a 1 sample one-sided decision function with an
arbitrary number of conditions which have all to be met.
}
\details{
The function creates a one-sided decision function which
takes two arguments. The first argument is expected to be a mixture
(posterior) distribution. This distribution is tested whether it
fulfills all the required threshold conditions specified with the
\code{pc} and \code{qc} arguments and returns 1 of all conditions
are met and 0 otherwise. Hence, for \code{lower.tail=TRUE}
condition \eqn{i} is equivalent to

\deqn{P(x \leq q_{c,i}) > p_{c,i}}

and the decision function is implemented as indicator function on
the basis of the heavy-side step function \eqn{H} which is \eqn{0}
for \eqn{x \leq 0} and \eqn{1} for \eqn{x > 0}. As all conditions
must be met, the final indicator function returns

\deqn{\Pi_i H_i(P(x \leq q_{c,i}) - p_{c,i} ).}

When the second argument is set to \code{TRUE} a distance metric is
returned component wise as

\deqn{ D_i = \log(P(p < q_{c,i})) - \log(p_{c,i}) .}

These indicator functions can be used as input for 1-sample OC
calculations using \code{\link{oc1S}}.
}
\seealso{
oc1S
}
