% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{dbGetTables}
\alias{dbGetTables}
\alias{dbGetTables,AthenaConnection-method}
\title{List Athena Schema, Tables and Table Types}
\usage{
dbGetTables(conn, ...)

\S4method{dbGetTables}{AthenaConnection}(conn, schema = NULL, ...)
}
\arguments{
\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{...}{Other parameters passed on to methods.}

\item{schema}{Athena schema, default set to NULL to return all tables from all Athena schemas.
Note: The use of DATABASE and SCHEMA is interchangeable within Athena.}
}
\value{
\code{dbGetTables()} returns a data.frame.
}
\description{
Method to get Athena schema, tables and table types return as a data.frame
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)
library(RAthena)

# Demo connection to Athena using profile name
con <- dbConnect(RAthena::athena())

# Return hierarchy of tables in Athena
dbGetTables(con)

# Disconnect conenction
dbDisconnect(con)
}
}
