% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg.model.R
\name{reg.model}
\alias{reg.model}
\title{Regression Analysis for Zero-altered or Zero-inflated Data}
\usage{
reg.model(x, y, b0 = NULL, dist = "ZIP", link)
}
\arguments{
\item{x}{a design matrix containing an intercept column (all ones) along with other available covariates available and selected for the response variable}

\item{y}{a zero-inflated or zero-altered(Hurdle) count response variable, represented as an integer vector}

\item{b0}{the initial parameters for the model, calculated as the product of the number of parameters in the specified models and the number of covariates. For simplicity one may put the MLE and intercept of the parameters and set the rest of covariates to zero or change them.}

\item{dist}{can be specified as follows: "ZIP" for "zero-inflated Poisson",
"ZINB" for "zero-inflated negative binomial",
"ZINB-r" for "zero-inflated negative binomial with fixed r",
"ZIBNB" for "zero-inflated beta negative binomial",
"ZIBB" for "zero-inflated beta binomial",
"ZIBB-n" for "zero-inflated beta binomial with fixed n",
"ZIBB-ab" for "zero-inflated beta binomial with fixed alpha and beta",
"PH" for "zero-altered(hurdle) Poisson",
"NBH" for "zero-altered(Hurdle) negative binomial",
"NBH-r" for "zero-altered (Hurdle) negative binomial with fixed r",
"BNBH" for " zero-altered (Hurdle) beta negative binomial",
"BBH" for "zero-altered (Hurdle) beta binomial",
"BBH-n" for "zero-altered(Hurdle) beta binomial with fixed n",
and "BBH-ab" for "zero-altered(Hurdle) beta binomial with fixed alpha and beta".}

\item{link}{can be set to one of four different options: "logit" for the logistic link function,
"probit" for the probit link function,
"loglog" for the log-log link function,
and "cloglog" for the complementary log-log link function}
}
\value{
A list containing AIC, BIC, the corresponding value of log likelihood, and the maximum likelihood estimate (MLE) of the unknown parameters in the model.
If dist = ZIP, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log.likelihhod: The value of log likelihood with maximum likelihood estimate plugged-in.
\item Estimated.Parameters: The maximum likelihood estimate of \eqn{\Gamma} and \eqn{\beta} for intercept and covariates included in the design matrix.
}
If dist = ZINB, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\Gamma}), (\eqn{\beta_1}), and (\eqn{\beta_2}) for intercept and covariates included in the design matrix.
}
If dist = ZINB-r, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\beta_1}) for intercept only and (\eqn{\Gamma}), and (\eqn{\beta_2}) for intercept and covariates included in the design matrix.
}
If dist = ZIBNB, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\Gamma}), (\eqn{\beta_1}), (\eqn{\beta_2}), and (\eqn{\beta_3}) for intercept and covariates included in the design matrix.
}
If dist = ZIBB, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\Gamma}), (\eqn{\beta_1}), (\eqn{\beta_2}), and (\eqn{\beta_3}) for intercept and covariates included in the design matrix.
}
If dist = ZIBB-n, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\beta_1}) for intercept only and (\eqn{\Gamma}),  (\eqn{\beta_2}), and (\eqn{\beta_3}) for intercept and covariates included in the design matrix.
}
If dist = ZIBB-ab, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\beta_2}) and (\eqn{\beta_3}) for intercept only and (\eqn{\Gamma}) and (\eqn{\beta_1}) for intercept and covariates included in the design matrix.
}
If dist = PH, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item  Estimated.Parameters: The maximum likelihood estimate of \eqn{\Gamma} and \eqn{\beta} for intercept and covariates included in the design matrix.
}
If dist = NBH, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\Gamma}), (\eqn{\beta_1}), and (\eqn{\beta_2}) for intercept and covariates included in the design matrix.
}
If dist = NBH-r, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\beta_1}) for intercpet only anf (\eqn{\Gamma}), and (\eqn{\beta_2}) for intercept and covariates included in the design matrix.
}
If dist = BNBH, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\Gamma}), (\eqn{\beta_1}), (\eqn{\beta_2}), and (\eqn{\beta_3}) for intercept and covariates included in the design matrix.
}
If dist = BBH, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\Gamma}), (\eqn{\beta_1}), (\eqn{\beta_2}), and (\eqn{\beta_3}) for intercept and covariates included in the design matrix.
}
If dist = BBH-n, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\beta_1}) for intercpet only and (\eqn{\Gamma}), (\eqn{\beta_2}), and (\eqn{\beta_3}) for intercept and covariates included in the design matrix.
}
If dist = BBH-ab, the following values are returned:
\itemize{
\item AIC: Akaike Information Criterion, a measure of the model's goodness of fit adjusted for the number of parameters.
\item BIC: Bayesian Information Criterion, a criterion for model selection among a finite set of models.
\item log-likelihood: The value of log-likelihood corresponding to the maximum likelihood estimate.
\item Estimated Parameters: Maximum likelihood estimates of (\eqn{\beta_2}) and (\eqn{\beta_3}) for intercept only and (\eqn{\Gamma}) and (\eqn{\beta_1}), for intercept and covariates included in the design matrix.
}
}
\description{
Regression Analysis for Zero-altered or Zero-inflated Data
}
\examples{
intercept<- rep(1,4406)
dt = DebTrivedi[, c(6:8, 13, 15, 18)]
dt = cbind(intercept, dt)
dt$gender.male <- ifelse(dt$gender == 'male', 1, 0)
dt$gender.female <- ifelse(dt$gender == 'female', 1, 0)
dt$health.poor <- ifelse(dt$health == 'poor', 1, 0)
dt$health.average <- ifelse(dt$health == 'average', 1, 0)
dt$health.excellent <- ifelse(dt$health == 'excellent', 1, 0)
dt$privins.yes <- ifelse(dt$privins == 'yes', 1, 0)
dt$privins.no <- ifelse(dt$privins == 'no', 1, 0)
y = DebTrivedi[,1]
x = data.matrix(dt[, c(1, 2, 4, 6, 8, 10, 12, 13)])
np = dim(x)[2]
b0 = c(rep(0.3, np), rep(0.1, np))
reg.model(x, y, b0=b0, dist="PH", link="logit")
}
