% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annotate}
\alias{annotate}
\title{evaluate ramSearch, MSFinder mssearch, MSFinder Structure, MSFinder Formula, and findmain output to annotate spectra of ramclustR object}
\usage{
annotate(
  ramclustObj = NULL,
  standardize.names = FALSE,
  min.msms.score = 0.8,
  database.priority = NULL,
  database.priority.factor = 0.1,
  find.inchikey = TRUE,
  taxonomy.inchi = NULL,
  taxonomy.inchi.factor = 0.1,
  use.ri = TRUE,
  sri = 300,
  ri.na.factor = 0.6,
  reset = TRUE
)
}
\arguments{
\item{ramclustObj}{R object - the ramclustR object which was used to write the .mat or .msp files}

\item{standardize.names}{logical: if TRUE, use inchikey for standardized chemical name lookup (http://cts.fiehnlab.ucdavis.edu/)}

\item{min.msms.score}{numerical: what is the minimum MSFinder similarity score acceptable.  default = 6.5}

\item{database.priority}{character.  Formula assignment prioritization based on presence in one or more (structure) databases.  Can be set to a single or multiple database names.  must match database names as they are listed in MSFinder precisely. Can also be set to 'all' (note that MSFinder reports all databases matched, not just databases in MSFinder parameters).  If any database is set, the best formula match to any of those databases is selected, rather than the best formula match overall.  If NULL, this will be set to include all selected databases (from ramclustObj$msfinder.dbs, retrieved from search output during import.msfinder.formulas(), when available) or 'all'.}

\item{database.priority.factor}{numeric, between 0 and 1.  0.1 by default.  The proportion by which scores for structures not in priority database are assessed}

\item{find.inchikey}{logical.  default = TRUE. use chemical translation service to try to look up inchikey for chemical name.}

\item{taxonomy.inchi}{vector or data frame.  Only when rescore.structure = TRUE.  user can supply a vector of inchikeys.  If used, structures which match first block of inchikey retain full score, while all other structures are penalized.}

\item{taxonomy.inchi.factor}{numeric, between 0 and 1.  0.1 by default.  The proportion by which scores for structures not in taxonomy.inchi vector are assessed}

\item{use.ri}{logical.  default = TRUE.  If retention index is available in ramclustObj (set by 'rc.calibrate.ri') and in library spectra from MSFinder, use RI similiarity to rescore.}

\item{sri}{numeric.  sigma value for retention index. controls decay rate of retention index curve. decay rate between 0 and 1 exported, and multiplied by spectrum score, totalscore.}

\item{ri.na.factor}{numeric. between 0 and 1.  0.5 by default.  how should spectrum scores be treated when no retention index is available?  NA values are replaced by retention index similarities of ri.na.factor when use.ri = TRUE.}

\item{reset}{logical.  If TRUE, removes any previously assigned annotations.}
}
\value{
an updated ramclustR object, with the at $msfinder.formula, $msfinder.formula.score,  $ann, and $ann.conf slots updated to annotated based on output from 1. ramsearch output, 2. msfinder mssearch, 3. msfinder predicted structure, 4. msfinder predicted formula, and 5. interpretMSSpectrum inferred molecular weight, with listed order as priority.
}
\description{
After running RAMSearch (msp) and MSFinder on .mat or .msp files, import the spectral search results
}
\details{
this function imports the output from the MSFinder program to annotate the ramclustR object
}
\references{
Broeckling CD, Afsar FA, Neumann S, Ben-Hur A, Prenni JE. RAMClust: a novel feature clustering method enables spectral-matching-based annotation for metabolomics data. Anal Chem. 2014 Jul 15;86(14):6812-7. doi: 10.1021/ac501530d.  Epub 2014 Jun 26. PubMed PMID: 24927477.

Broeckling CD, Ganna A, Layer M, Brown K, Sutton B, Ingelsson E, Peers G, Prenni JE. Enabling Efficient and Confident Annotation of LC-MS Metabolomics Data through MS1 Spectrum and Time Prediction. Anal Chem. 2016 Sep 20;88(18):9226-34. doi: 10.1021/acs.analchem.6b02479. Epub 2016 Sep 8. PubMed PMID: 7560453.

Tsugawa H, Kind T, Nakabayashi R, Yukihira D, Tanaka W, Cajka T, Saito K, Fiehn O, Arita M. Hydrogen Rearrangement Rules: Computational MS/MS Fragmentation and Structure Elucidation Using MS-FINDER Software. Anal Chem. 2016 Aug 16;88(16):7946-58. doi: 10.1021/acs.analchem.6b00770. Epub 2016 Aug 4. PubMed PMID: 27419259.

http://cts.fiehnlab.ucdavis.edu/static/download/CTS2-MS2015.pdf
}
\author{
Corey Broeckling
}
\concept{MSFinder}
\concept{RAMClustR}
\concept{clustering}
\concept{feature}
\concept{mass spectrometry}
\concept{metabolomics}
\concept{ramlclustR}
\concept{xcms}
