% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.merge.data.r
\name{lsa.merge.data}
\alias{lsa.merge.data}
\title{Merge study data from different countries and/or respondents}
\usage{
lsa.merge.data(inp.folder, file.types, ISO, out.file)
}
\arguments{
\item{inp.folder}{Folder containing the data sets. The data sets must be \code{.RData}, produced
by \code{lsa.convert.data}. See details.}

\item{file.types}{What file types (i.e. respondents) shall be merged? See details.}

\item{ISO}{Vector containing character ISO codes of the countries' data files to include
in the merged file. See details.}

\item{out.file}{Full path to the file the data shall be stored in. The object stored in the
file will have the same name. See details.}
}
\value{
\code{.RData} data file containing an object with class \code{lsa.data}, an extension of the \code{data.table} class. The \code{data.table} object has the same name as the \code{.RData} file it is saved in. The object contains the data from different respondents and/or countries merged and has additional attributes: study name (\code{study}), study cycle (\code{cycle}), and respondent file type (\code{file.type}). Each variable has its own additional attributes: its own label attached to it, if it existed in the source SPSS file. If the \code{missing.to.NA} in the source file was set to \code{TRUE}, each variable has an attribute \code{missings}, containing the user-defined missing values.
}
\description{
\code{lsa.merge.data} combines data from different countries and/or different respondents (e.g. students and teachers, or students and schools).
}
\details{
The function merges files from studies where the files are per country and respondent type (e.g. student, school, teacher). That is, all studies except PISA.

The \code{inp.folder} specifies the path to the folder containing the \code{.RData} files produced by \code{lsa.convert.data}. The folder must contain only files for a single study, single cycle and single population (e.g. TIMSS 2015 grade 4 or TIMSS 2015 grade 8, but not both), or mode of administration (e.g. either PIRLS 2016 or ePIRLS 2016, but not both; or TIMSS 2019 or TIMSS 2019 Bridge, but not both). All files in the input folder must be exported with the same option (\code{TRUE} or \code{FALSE}) of the \code{missing.to.NA} argument of the \code{lsa.convert.data} function. If input folder is not provided to the argument, the working folder (\code{getwd()}) will be used.

The \code{file.types} is a list of the respondent types as component names and their variables as elements to be merged. The file type names are three-character codes, the first three characters of the corresponding file names. The elements are vectors of upper case variable names, \code{NULL} takes all variables in the corresponding file. For example, in TIMSS \code{asg} will merge only student-level data from grade 4, \code{c(asg, atg)} will merge the student-level and teacher-level data from grade 4, \code{c(bsg, btm)} will merge student-level and mathematics teacher-level data from grade 8. If a merge is not possible by the study design, the function will stop with an error. See the examples.

The \code{ISO} is a character vector specifying the countries whose data shall be merged. The elements of the vector are the fourth, fifth and sixth characters in the file names. For example, \code{c("aus", "swe", "svn")} will merge the data from Australia, Sweden and Slovenia for the file types specified in \code{file.types}. The three-letter ISO codes for each country can be found in the user guide for the study in scope. For example, the ISO codes of the countries participating in PIRLS 2016 can be found in its user guide on pages 52-54. If file for specific country does not exist in the \code{inp.folder}, a warning will be issued. If the \code{ISO} argument is missing, the files for all countries in the folder will be merged for the specified \code{file.types}.

The \code{out.file} must contain full path (including the \code{.RData} extension, if missing, it will be added) to the output file (i.e. the file containing merged data). The file contains object with the same name and has a class extension \code{lsa.data}. It has additional attribute \code{file.type} showing data from which respondents is available after the merging has been done. For example, merging the student-level data with teacher-level data in TIMSS grade 4 will assign "std.bckg.tch.bckg" to this attribute. The object has two additional attributes: study name (\code{study}) and study cycle (\code{cycle}). The object in the \code{.RData} file is keyed on the country ID variable. If output folder is not provided, the merged file will be saved in the working folder (\code{getwd()}) as \code{merged_data.RData}.
}
\examples{

# Merge TIMSS 2015 grade 4 student and teacher variables for Australia, Chinese Taipei and
# Slovenia taking all variables in both files
\dontrun{
lsa.merge.data(inp.folder = "C:/Data", file.types = list(asg = NULL, atg = NULL),
ISO = c("aus", "twn", "svnn"), out.file = "C:/Merged/Merged.RData")
}

# Same as the above, taking just few variables from each file
\dontrun{
lsa.merge.data(inp.folder = "C:/Data",
file.types = list(asg = c("ASBG01", "ASBG02A", "ASBG02B"),
atg = c("ATBG01", "ATBG02", "ATBG03")), ISO = c("aus", "twn", "svnn"),
out.file = "C:/Merged/Merged.RData")
}

}
\references{
Foy, P. (Ed.). (2018). \emph{PIRLS 2016 User Guide for the International Database}. TIMSS & PIRLS International Study Center.
}
\seealso{
\code{\link{lsa.convert.data}}
}
