#' Rice_Zhao_etal:
#'
#' Marker genotype and phenotype data of rice by Zhao et al., 2010.
#'
#'
#' @description A list containing the information of marker genotype of rice genome (Zhao et al., 2010; PLoS One 5(5): e10780)
#' and phenotype data of rice field trial (Zhao et al., 2011; Nat Comm 2:467).
#'
#' @format A list of 4 data frames:
#' \describe{
#'   \item{$genoScore}{marker genotyope, \link{Rice_geno_score}}
#'   \item{$genoMap}{physical map, \link{Rice_geno_map}}
#'   \item{$pheno}{phenotype, \link{Rice_pheno}}
#'   \item{$haploBlock}{haplotype block, \link{Rice_haplo_block}}
#' }
#' @source \url{http://www.ricediversity.org/data/}
#'
#' @seealso \link{Rice_geno_score}, \link{Rice_geno_map}, \link{Rice_pheno}, \link{Rice_haplo_block}
#'
#' @references
#' Zhao K, Wright M, Kimball J, Eizenga G, McClung A, Kovach M, Tyagi W, Ali ML, Tung CW, Reynolds A, Bustamante CD, McCouch SR (2010). Genomic Diversity and Introgression in O. sativa Reveal the Impact of Domestication and Breeding on the Rice Genome. PLoS One. 2010; 5(5): e10780.
#' Zhao, K. et al. (2011) Genome-wide association mapping reveals a rich genetic architecture of complex traits in Oryza sativa. Nat Commun. 2: 467.
#' Purcell, S. and Chang, C. (2018). PLINK 1.9, www.cog-genomics.org/plink/1.9/.
#' Chang CC, Chow CC, Tellier LCAM, Vattikuti S, Purcell SM, Lee JJ (2015) Second-generation PLINK: rising to the challenge of larger and richer datasets. GigaScience, 4.
#' Gaunt T, Rodríguez S, Day I (2007) Cubic exact solutions for the estimation of pairwise haplotype frequencies: implications for linkage disequilibrium analyses and a web tool 'CubeX'. BMC Bioinformatics, 8.
#' Taliun D, Gamper J, Pattaro C (2014) Efficient haplotype block recognition of very long and dense genetic sequences. BMC Bioinformatics, 15.
"Rice_Zhao_etal"
