% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{format_currency}
\alias{format_currency}
\alias{format_percent}
\title{Printing currency values or percentages}
\usage{
format_currency(
  x,
  prefix = "",
  suffix = "",
  big.mark = ",",
  accuracy = NULL,
  min_length = NULL,
  ...
)

format_percent(x, accuracy = 0.1, ...)
}
\arguments{
\item{x}{A numeric vector}

\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.
The default (\code{NULL}) retrieves the setting from the
\link[scales:number_options]{number options}.}

\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{min_length}{A numeric. Minimum number of characters
of the string with the formatted value.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}
}
\value{
A character. Formatted value.

A character. Formatted value.
}
\description{
Wrapper functions for printing nicely formatted values.
}
\examples{
format_currency(2345678, suffix = " PLN")
format_percent(0.52366)
}
\seealso{
\code{\link[scales:dollar_format]{scales::dollar()}}

\code{\link[scales:percent_format]{scales::percent()}}
}
