% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltx_table_design.r
\name{ltx_table_design}
\alias{ltx_table_design}
\title{Designs a table based on a object returned by the table_prep function}
\usage{
ltx_table_design(dfl, uselabel = TRUE, yhead = FALSE, footnote = "",
  mancol = NULL, size = "\\\\normalsize", title = "table",
  titlepr = NULL, xabove = TRUE, group = NULL, xrepeat = FALSE,
  hyper = TRUE)
}
\arguments{
\item{dfl}{list generated by the table_prep function which serves as the base of the table to be generated}

\item{uselabel}{logical indicating if labels should be used for the x variable(s).
If set to TRUE, the function will try to use the label attribute for the display of x variable(s).}

\item{yhead}{logical indicating if the y variable should also be set as header in the table.}

\item{footnote}{character string with the footnote to be placed in the footer of the page (LaTeX coding can be used for example to create line breaks)}

\item{mancol}{character string to define manual column alignment. in case argument is NULL, a sensible default will be set.}

\item{size}{character string to define the font size of the table}

\item{title}{character string to define the title of the table which will be added to the caption}

\item{titlepr}{character string to define the prefix of the table title. Can be used to create custom table numbering}

\item{xabove}{logical indicating if the first unique x variable should be placed in the table row above. Mostly used to save space on a page}

\item{group}{number indicating which x variables should be grouped (displayed in table with a certain white space) and interpreted as x[1:group]}

\item{xrepeat}{logical indicating if duplicate x values should be repeated in the table or not}

\item{hyper}{logical indicating if a hypertarget should be set used for bookmarks}
}
\value{
The function returns a vector that defines the entire latex table. This vector can be adapted manually
  however it is intended to be used in a print function to add to a latex document.
}
\description{
This function designs the a latex table based on the data frame list returned by the table_prep function.
}
\details{
This function designs a latex pivot table based on the results of the table_prep output. This means that the function
  Should always be used in conjunction with this function.
}
\examples{

\dontrun{ltx_table_design(lstobject)}
}
