% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_headed.R
\name{read_headed}
\alias{read_headed}
\title{Read capture-recapture data with Headed format used by program E-SURGE}
\usage{
read_headed(file)
}
\arguments{
\item{file}{text file with Headed format}
}
\value{
list with first component the matrix of encounter histories, second components the vector of number of individuals with corresponding histories and, if relevant, third component vector/matrix with group(s)
}
\description{
This function reads in capture-recapture dataset with the Headed format.
It ignores all forms of censorship for now, and drops continuous covariates because no goodness-of-fit test exists for such models
}
\examples{
# read in Dipper dataset
dipper = system.file("extdata", "ed.txt", package = "R2ucare")
read_headed(dipper)
# read in Geese dataset
geese = system.file("extdata", "geese.txt", package = "R2ucare")
read_headed(geese)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>
}
\keyword{package}
