% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_data.R
\name{group_data}
\alias{group_data}
\title{Group individual capture-recapture data in encounter histories}
\usage{
group_data(X, effX)
}
\arguments{
\item{X}{matrix of capture-recapture histories}

\item{effX}{vector with numbers of individuals with that particular capture-recapture history}
}
\value{
matrix with grouped capture-recapture histories and counts in the last column
}
\description{
This function pools together individuals with the same encounter capture-recapture history.
}
\examples{
# Generate fake capture-recapture dataset
X = matrix(round(runif(300)),nrow=100)
freq=rep(1,100)
cbind(X,freq)
group_data(X,freq)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>, Roger Pradel, Rémi Choquet
}
\keyword{package}

