% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caterpillarR.R
\name{caterpillarR}
\alias{caterpillarR}
\title{Draws caterpillar plots of the residuals from a mlwinfitIGLS-class or
mlwinfitMCMC-class object, at a chosen level of the multilevel model.}
\usage{
caterpillarR(resi, lev = 2)
}
\arguments{
\item{resi}{A \code{\link{mlwinfitIGLS-class}} or
\code{\link{mlwinfitMCMC-class}} object (model must be fitted specifying
\code{resi.store = TRUE} and including \code{'variances'} or \code{'sampling'} in the list of
\code{resioptions} (both in \code{estoptions}) to not return an error).}

\item{lev}{An integer scalar specifying the level of a multilevel model
for which to produce a plot for.}
}
\value{
See \code{\link[lattice]{qqmath}}.
}
\description{
Uses \code{\link[lattice]{qqmath}} in the \pkg{lattice} package to draw Quantile-Quantile plots
of the residuals at a chosen level of a multilevel model against a
theoretical distribution.
}
\examples{
\dontrun{
library(R2MLwiN)
# NOTE: if MLwiN not saved where R2MLwiN defaults to:
# options(MLwiN_path = 'path/to/MLwiN vX.XX/')
# If using R2MLwiN via WINE, the path may look like:
# options(MLwiN_path = '/home/USERNAME/.wine/drive_c/Program Files (x86)/MLwiN vX.XX/')

# Example using tutorial dataset
data(tutorial, package = 'R2MLwiN')
mymodel <- runMLwiN(normexam ~ 1 + (1 | school) + (1 | student),
                    estoptions = list(resi.store = TRUE),
                    data = tutorial)
# Caterpillar plot
caterpillarR(mymodel['residual'], lev = 2)
}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2015) Centre for Multilevel Modelling, University of Bristol.
}
\seealso{
\code{\link{caterpillar}}, \code{\link[lattice]{qqmath}}
}

