% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R
\name{concordances}
\alias{concordances}
\title{concordances}
\usage{
concordances(corpus, dtm, terms, all = FALSE)
}
\arguments{
\item{corpus}{A \code{Corpus} object.}

\item{dtm}{A \code{DocumentTermMatrix} object corresponding to \code{corpus}.}

\item{terms}{One of more terms appearing in \code{dtm}.}

\item{all}{Whether only documents containing all terms should be printed.
By default, documents need to contain at least one of the terms.}
}
\value{
\code{Corpus} object (invisibly).
}
\description{
Print documents which contain one or more terms and return
a sub-corpus with these documents.
}
\details{
Occurrences of the specified terms are highlighted. If stemming
or other transformations have been applied to original words using
\code{\link{combine_terms}}, all original words which have been transformed
to the specified terms are highlighted.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
concordances(corpus, dtm, "oil")
concordances(corpus, dtm, c("oil", "opec"))
concordances(corpus, dtm, c("oil", "opec"), all=TRUE)

# Also works when terms have been combined
dict <- dictionary(dtm)
dtm2 <- combine_terms(dtm, dict)
concordances(corpus, dtm2, "product")

}
