% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdate.R
\name{rdate}
\alias{rdate}
\title{Generate Random Dates, with a similar usage as the r* functions}
\usage{
rdate(
  x,
  min = paste0(format(Sys.Date(), "\%Y"), "-01-01"),
  max = paste0(format(Sys.Date(), "\%Y"), "-12-31"),
  sort = FALSE,
  include_hours = FALSE
)
}
\arguments{
\item{x}{Integer. Length of the output vector
(number of random dates to generate).}

\item{min}{Date. Optional. The minimum date for the range.
Defaults to the 1st of January of the current year.}

\item{max}{Date. Optional. The maximum date for the range.
Defaults to the 31st of December of the current year.}

\item{sort}{Logical. Should the dates be sorted in ascending order?
Default is `FALSE`.}

\item{include_hours}{Logical. Should the generated dates include time?
Default is `FALSE` (dates only). this will slow down the function}
}
\value{
A vector of random dates of length `x`.
}
\description{
Generates a vector of random dates within a specified range.
This function tries to replicate the usage of the r* functions from stats
package, such as runif(), rpois(), ...
}
\examples{
# Generate 5 random dates between two specific dates, sorted
rdate(5, min = as.Date("2020-01-01"), max = as.Date("2020-12-31"), sort = TRUE)

# Generate 7 random datetime values (with hours)
rdate(7, include_hours = TRUE)

}
