% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{parallelEM}
\alias{parallelEM}
\title{Expectation Maximization algorithm}
\usage{
parallelEM(Schrod, nclust, epsilon, contamination, prior_center = NULL,
  prior_weight = NULL, Initializations = 1, optim = "default",
  keep.all.models = FALSE)
}
\arguments{
\item{Schrod}{A list of dataframes (one for each sample), generated by the Patient_schrodinger_cellularities() function.}

\item{nclust}{Number of clones to look for (mandatory if prior_center or prior_weight are null)}

\item{epsilon}{Stopping condition for the algorithm: what is the minimal tolerated difference of position or weighted between two steps}

\item{contamination}{Numeric vector with the fraction of normal cells contaminating the sample}

\item{prior_center}{Clone coordinates (from another analysis) to be used}

\item{prior_weight}{Prior on the fraction of mutation in each clone}

\item{Initializations}{Maximal number of independant initial condition tests to be tried}

\item{optim}{use L-BFS-G optimization from R ("default"), or from optimx ("optimx"), or Differential Evolution ("DEoptim")}

\item{keep.all.models}{Should the function output the best model (default; FALSE), or all models tested (if set to true)}
}
\description{
Optimization of clone positions and proportion of mutations in each clone followed 
by filtering on most likely possibility for each mutation and a re-optimization. Then gives out the possibility with maximal likelihood
Relies on foreach
}
\keyword{EM}
