% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.fmx.R
\name{autoplot_fmx}
\alias{autoplot_fmx}
\alias{autoplot.fmx}
\title{Plot \linkS4class{fmx} and \linkS4class{fmx_QLMDe} objects using \CRANpkg{ggplot2}}
\usage{
\method{autoplot}{fmx}(
  object,
  type = c("density", "distribution"),
  data = attr(object, which = "data", exact = TRUE),
  epdf = attr(object, which = "epdf", exact = TRUE),
  probs = attr(object, which = "p", exact = TRUE),
  init = attr(object, which = "init", exact = TRUE),
  origK = attr(object, which = "orig_K", exact = TRUE),
  xlim = if (!length(data)) qfmx(p = c(0.01, 0.99), dist = object),
  hist.fill = "grey95",
  hist.col = "white",
  curve.col = 1,
  xlab = attr(object, which = "data.name", exact = TRUE),
  ylab = paste(object@distname, "mixture"),
  title = TeX(fmx_constraint_brief(object)),
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{an \linkS4class{fmx} or \linkS4class{fmx_QLMDe} object}

\item{type}{\link[base]{character} scalar.
Option \code{'density'} (default) plots the probability density for \linkS4class{fmx} input or 
the histogram and the estimated probability density for \linkS4class{fmx_QLMDe} input.
Option \code{'distribution'} plots the cumulative probability distribution for \linkS4class{fmx} input or 
the empirical cumulative distribution together with the estimated cumulative distribution function
for \linkS4class{fmx_QLMDe} input.}

\item{data}{(optional) \link[base]{numeric} vector of the observations.
For \linkS4class{fmx_QLMDe} input, the default is \code{object@data}.}

\item{epdf}{..}

\item{probs}{\link[base]{numeric} vector, 
the percentages (to be) used in \code{\link{QLMDe}}, can be plotted as vertical lines.
Use \code{probs = NULL} to suppress the printing of these lines.}

\item{init}{\link[base]{logical} scalar, whether to plot the initial estimates used in \code{\link{QLMDe}}, default \code{FALSE}.}

\item{origK}{\link[base]{logical} scalar, 
whether to plot the \linkS4class{fmx_QLMDe} at the user-specified number of components \eqn{K}
if backward-forward selection on number of component is performed, default \code{FALSE}.}

\item{xlim}{horizontal range, see \link[ggplot2]{stat_function}.}

\item{hist.fill}{color of the body of histogram, default \code{'grey95'}.
Passed as parameter \code{fill} in \link[ggplot2]{geom_histogram}.}

\item{hist.col}{color of the border around the histogram bars, default \code{'white'}.
See parameter \code{colour} of \link[ggplot2]{geom_histogram}.}

\item{curve.col}{color of the density curve of the fitted finite mixture distribution.
Passed as parameter \code{colour} in \link[ggplot2]{stat_function}.}

\item{xlab, ylab, title, caption}{\link[base]{character} scalars, the 
horizontal and vertical label, title and caption.
See \code{\link[ggplot2]{xlab}}, \code{\link[ggplot2]{ylab}}, \link[ggplot2]{labs}.}

\item{...}{potential parameters of \link[ggplot2]{stat_function}}
}
\value{
\link{autoplot.fmx} returns a \link[ggplot2]{ggplot} object.
}
\description{
Plot \linkS4class{fmx} and \linkS4class{fmx_QLMDe} objects using \CRANpkg{ggplot2}.
}
\examples{
(d2 = fmx('GH', A = c(1,6), B = 2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
curve(dfmx(x, dist = d2), xlim = c(-3, 11))
curve(pfmx(x, dist = d2), xlim = c(-3, 11))
autoplot(d2)
autoplot(d2, type = 'distribution')

}
\seealso{
\link[ggplot2]{autoplot}
}
