% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlFRindex.R
\docType{class}
\name{nlFRindex}
\alias{nlFRindex}
\alias{nlFRindex-class}
\alias{predict.nlFRindex}
\title{Nonlinear Functional Regression Indices}
\usage{
nlFRindex(
  formula,
  data,
  xarg = as.double(colnames(X)),
  family,
  fit = TRUE,
  ...
)

\method{predict}{nlFRindex}(object, newdata, ...)
}
\arguments{
\item{formula}{a two-sided \link[stats]{formula}.
\describe{
\item{Left-hand-side}{is the \link[base]{name} of the response \eqn{y}.
Supported types of responses are \link[base]{double}, \link[base]{logical} and \link[survival]{Surv}.}
\item{Right-hand-side}{is the \link[base]{name}
of the tabulated \link[base]{double} \link[base]{matrix} \eqn{X} of functional predictor values.
Each row of \eqn{X} represents the tabulated values for a subject.
All rows/subjects are tabulated on a common grid \code{xarg}.
Each column of \eqn{X} represents the tabulated values at a point on the common grid for each subject.}
}}

\item{data}{\link[base]{data.frame}, with
the response \eqn{y} and the tabulated functional predictor values \eqn{X}
specified in \code{formula}.
If the functional predictor is the \link[stats]{quantile} function,
then \code{data} is preferably the returned object of \code{\link[=clusterQp]{clusterQp()}}.}

\item{xarg}{\link[base]{numeric} \link[base]{vector}.
The default argument comes from the column names of the \link[base]{matrix} of
tabulated functional predictor values \eqn{X}.
This is particularly convenient when
the functional predictor is the \link[stats]{quantile} function,
and \code{data} is the returned object of function \code{\link[=clusterQp]{clusterQp()}}.
The user-provided \code{xarg} will be checked such that
\enumerate{
\item \code{xarg} is a \link[base]{numeric} \link[base]{vector} without missingness
\item \link[base]{length} of \code{xarg} is the same as the number of columns of \link[base]{matrix} \eqn{X}
\item \code{xarg} must be strictly sorted (see \link[base]{is.unsorted})
}
Otherwise, an error message will be returned.}

\item{family}{..}

\item{fit}{\link[base]{logical} scalar, see \link[mgcv]{gam}}

\item{...}{additional parameters, currently not in use}

\item{object}{an \linkS4class{nlFRindex} object for the \link[stats]{predict} method,
the returned object from function \code{\link[=nlFRindex]{nlFRindex()}}}

\item{newdata}{\link[base]{data.frame}, with at least
the tabulated functional predictor values \eqn{X^{new}}
based on \code{object@formula}}
}
\value{
\subsection{Functional regression indices & weights model}{

Function \code{\link[=nlFRindex]{nlFRindex()}} returns an \link[base]{S4} \linkS4class{nlFRindex} object.
The slots of \link[base]{S4} class \linkS4class{nlFRindex} are described in section \strong{Slots}.
}

\subsection{Predict method for non-linear functional regression indices}{

Function \code{\link[=predict.nlFRindex]{predict.nlFRindex()}} returns a
\link[base]{double} \link[base]{vector},
which is the predicted non-linear functional regression indices.
}
}
\description{
Functions explained in this documentation are,

\describe{

\item{\code{\link[=nlFRindex]{nlFRindex()}}}{
to compute the non-linear functional regression indices based on the functional predictors.}

\item{\code{\link[=predict.FRindex]{predict.FRindex()}}}{
to compute the predicted values based on functional regression indices model.}

}
}
\details{
\subsection{Functional regression indices & weights model}{

Function \code{\link[=nlFRindex]{nlFRindex()}} fits a non-linear functional regression model to the response \eqn{y}
using the functional predictor \eqn{X},
with values tabulated on a same grid \code{xarg} for all subjects (Cui et al, 2021).
}

\subsection{Predict method for non-linear functional regression indices}{

Function \code{\link[=predict.nlFRindex]{predict.nlFRindex()}} computes non-linear functional regression indices
based on the tabulated functional predictors \eqn{X^{new}} in a new sets of subjects.
It's important that the new tabulation grid must be exactly the same
as the model tabulation grid \code{object@xarg}.
}
}
\section{Slots}{

\describe{
\item{\code{formula,data,xarg}}{see explanations in section \strong{Arguments}}

\item{\code{gam}}{\link[mgcv]{gam} object}

\item{\code{p.value}}{\link[base]{numeric} scalar,
\eqn{p}-value for the test of significance of the functional predictor}

\item{\code{index}}{\link[base]{double} \link[base]{vector},
functional regression indices.}
}}

\examples{
pt = unique(Ki67$PATIENT_ID)
length(pt) # 622
# set.seed if necessary
train_pt = sample(pt, size = 500L)
Ki67q = clusterQp(Marker ~ ., data = Ki67, exclude = c('tissueID','inner_x','inner_y'))
train_q = subset(Ki67q, PATIENT_ID \%in\% train_pt)
test_q = subset(Ki67q, !(PATIENT_ID \%in\% train_pt))
train_q$Marker = log1p(train_q$Marker)
test_q$Marker = log1p(test_q$Marker)

# using Cox model
m = nlFRindex(Surv(RECFREESURV_MO, RECURRENCE) ~ Marker, data = train_q)
m@p.value # test significance of `Marker` as a functional predictor
train_index = predict(m, newdata = train_q) # non-linear FR index of training data
# stopifnot(identical(train_index, m@index))
predict(m, newdata = test_q) # non-linear FR index of test data

# using logistic regression model
nlFRindex(RECURRENCE ~ Marker, data = train_q)

# using Gaussian model
nlFRindex(RECFREESURV_MO ~ Marker, data = train_q)

}
\references{
Cui, E., Crainiceanu, C. M., & Leroux, A. (2021).
Additive Functional Cox Model. Journal of Computational and Graphical Statistics.
\doi{10.1080/10618600.2020.1853550}
}
