% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUALYPSO.r
\name{lm.ANOVA}
\alias{lm.ANOVA}
\title{lm.ANOVA}
\usage{
lm.ANOVA(phiStar, scenAvail, listOption = NULL, namesEff)
}
\arguments{
\item{phiStar}{matrix of climate change responses (absolute or relative changes): \code{nS} x \code{n}. \code{n} can be the number of time steps or the number of grid points}

\item{scenAvail}{data.frame \code{nS} x \code{nEff} with the \code{nEff} characteristics (e.g. type of GCM) for each of the \code{nS} x \code{nS} scenarios}

\item{listOption}{list of options (see \code{\link{QUALYPSO}})}

\item{namesEff}{names of the main effects}
}
\value{
list with the following fields:

\itemize{
  \item \strong{GRANDMEAN}: List of estimates for the grand mean:
  \itemize{
     \item {strong}: MEAN: vector of length \code{n} of means
     \item {strong}: SD: vector of length \code{n} of standard dev.
     \item {strong}: CI: matrix \code{n} x 2 of credible intervals of
     probability \code{probCI} given in \code{listOption}.
  }
  \item \strong{RESIDUALVAR}: List of estimates for the variance of the
  residual errors:
  \itemize{
     \item {strong}: MEAN: vector of length \code{n}
  }
  \item \strong{MAINEFFECT}: List of estimates for the main effects. For each
  main effect (GCM, RCM,..), each element of the list contains a list with:
  \itemize{
     \item {strong}: MEAN: matrix \code{n} x \code{nTypeEff}
  }
  \item \strong{CHANGEBYEFFECT}: For each main effect, list of estimates for
  the mean change by main effect, i.e. mean change by scenario (RCP4.5). For
  each main effect (GCM, RCM,..), each element of the list contains a list with:
  \itemize{
     \item {strong}: MEAN: matrix \code{n} x \code{nTypeEff}
  }
  \item \strong{EFFECTVAR}: variability related to the main effects (i.e.
  variability between the different RCMs, GCMs,..). Matrix \code{n} x
  \code{nTypeEff}
  \item \strong{CONTRIB_EACH_EFFECT}: Contribution of each individual effect
  to its component (percentage), e.g. what is the contribution of GCM1 to the
   variability related to GCMs. For each main effect (GCM, RCM,..), each
   element of the list contains a matrix \code{n} x \code{nTypeEff}
  \item \strong{listOption}: list of options used to obtained these results
   (obtained from \code{\link{QUALYPSO.check.option}})
  \item \strong{listScenarioInput}: list of scenario characteristics
   (obtained from \code{\link{QUALYPSO.process.scenario}})
}
}
\description{
Partition uncertainty in climate responses using an ANOVA inferred with a Bayesian approach.
}
\author{
Guillaume Evin
}
