% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.long.R
\name{gen.long}
\alias{gen.long}
\title{Dynamic Programming Algorithm}
\usage{
gen.long(y, x, vec.tau, n.size = 1, trim.size)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\code{NT × 1}).}

\item{x}{A numeric matrix of regressors (\code{NT × p}).}

\item{vec.tau}{A vector of quantiles of interest.}

\item{n.size}{The size of the cross-section; default is set to 1.}

\item{trim.size}{The minimum length of a regime (integer).}
}
\value{
A list containing:
\describe{
\item{mat.long}{A matrix of objective function values for separate quantiles.}
\item{vec.long}{A matrix of objective function values for combined quantiles.}
}
}
\description{
This function computes the objective function values for all possible segments of the sample.
}
\examples{

\donttest{
# This example may take substantial time for automated package checks
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]
n.size = 1
T.size = length(y) # number of time periods

# setting
vec.tau   = seq(0.20, 0.80, by = 0.150)
trim.e    = 0.2
trim.size = round(T.size * trim.e)  #minimum length of a regime

out.long   = gen.long(y, x, vec.tau, n.size, trim.size)

}

}
\references{
Bai, J and P. Perron (2003).
Computation and Analysis of Multiple Structural Change Models.
\emph{Journal of Applied Econometrics}, 18(1), 1-22.
}
