% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSDensity.R
\name{TSDensity}
\alias{TSDensity}
\title{Density plot from simulation of two-dimensional stochastic differential equations}
\usage{
TSDensity(mat, dim = 1, xlim = NULL, ylim = NULL, contour.levels = 15,
  col2d = c("blue", "yellow", "orange", "red"), contour.lwd = 0.5,
  contour.lines = TRUE, kde2d.n = 100, xlab = "X", ylab = "Y", ...)
}
\arguments{
\item{mat}{a matrix output from \code{\link{TSTraj}}.}

\item{dim}{dimensions of the plot; \code{dim = 1} plots simple density histogram or \code{dim = 2} plots the density in state space (i.e., X and Y respectively on the abscissa and ordinate axes).}

\item{xlim}{numeric vectors of length 2, giving the x coordinate range. Default \code{= NULL} automatically sizes plot window.}

\item{ylim}{numeric vectors of length 2, giving the y coordinate range. Default \code{= NULL} automatically sizes plot window.}

\item{contour.levels}{the number of contour levels for the two-dimensional plots (i.e., when \code{dim = 2}).}

\item{col2d}{vector of colors to be used in the plot.}

\item{contour.lwd}{line width of contour lines if \code{contour.lines = TRUE}.}

\item{contour.lines}{if \code{TRUE}, then black countour lines added to the graph.}

\item{kde2d.n}{number of grid points in each direction. Can be scalar or a length-2 integer vector.  Passes to argument \code{n} in \code{\link[MASS]{kde2d}}.}

\item{xlab}{label for x axis when dim = 2.  Default is 'X'}

\item{ylab}{label for y axis when dim = 2.  Default is 'Y'}

\item{...}{passes arguments to \code{\link{plot}}.}
}
\description{
This function creates density plots for the simulation of two-dimensional stochastic differential equations from \code{\link{TSTraj}}
}
\examples{
\dontrun{
# First, the parameter values, as found in TSTraj
model.state <- c(x = 3, y = 3)
model.sigma <- 0.2
model.deltat <- 0.005
model.time <- 100

# Second, write out the deterministic skeleton of the equations to be simulated, 
# as found in TSTraj
#Example 1 from article
equationx <- "1.54*x*(1.0-(x/10.14)) - (y*x*x)/(1.0 + x*x)"
equationy <- "((0.476*x*x*y)/(1 + x*x)) - 0.112590*y*y"

# Third, run it, as found in TSTraj
ModelOut <- TSTraj(y0 = model.state, time = model.time, deltat = model.deltat, 
	x.rhs = equationx, y.rhs = equationy, sigma = model.sigma)
# Fourth, plot it:
# in 1D
TSDensity(ModelOut, dim = 1)
# in 2D
TSDensity(ModelOut, dim = 2, kde2d.n = 20, xlab = "")
}
}
\keyword{plot}
\keyword{simulations}
\keyword{stochastic}

