% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_SimultaneousEst_MUFASA_Code.R
\name{p.SMUFASA}
\alias{p.SMUFASA}
\title{Returns SMUFASA calibration coefficient estimates and an overall diet among
a sample of predators.}
\usage{
p.SMUFASA(pred.mat, prey.mat, FC, ext.fa)
}
\arguments{
\item{pred.mat}{matrix containing the FA signatures of the predators.}

\item{prey.mat}{matrix containing  FA signatures from each prey group
The first column must index the prey
group.  \emph{prey.mat} is the prey database.}

\item{FC}{vector of fat content of length equal to the number of prey groups
or species.}

\item{ext.fa}{subset of fatty acids to be used to obtain QFASA diet estimates.}
}
\value{
A list with components:
\item{Cal_Estimates}{A vector of estimated calibration coefficients common
to all predators. The \emph{k} th value corresponds to the \emph{k} th
fatty acid. The estimates sum to the number of fatty acids.}
\item{Diet_Estimate}{A vector of estimates of the average diet among the
predators. The estimates are expressed as proportions summing to one.}
\item{nll}{Negative log likelihood values.  As per \emph{solnp} documentation,
           \emph{nll} is "Vector of function values during optimization with
           last one the value at the optimal".}
\item{Var_Epsilon}{Optimized values of error variance.}
}
\description{
Returns SMUFASA calibration coefficient estimates and an overall diet among
a sample of predators.
}
\details{
Calibration coefficients (CCs) are not supplied but are instead
         estimated.While one overall diet is computed, the CCs can be used
         in p.QFASA or p.MUFASA to estimate individual diet estimates.
}
\examples{

library(dplyr)
library(compositions)

 ##  This example takes some time to run.
 ## Please uncomment code below to run.


## Fatty Acids
#data(FAset)
#fa.set = as.vector(unlist(FAset))

## Predators
#data(predatorFAs)
#tombstone.info = predatorFAs[,1:4]
#predator.matrix = predatorFAs[,5:(ncol(predatorFAs))]
#npredators = nrow(predator.matrix)

## Prey
## Extracting a small number of species to speed up calculations for the example.
#data(preyFAs)
#prey.matrix = preyFAs[,-c(1,3)]
#spec.red <-c("capelin", "herring", "mackerel", "pilchard", "sandlance")
#spec.red <- sort(spec.red)
#prey.red <- prey.matrix \%>\% filter(Species \%in\% spec.red)

## Fat content
#FC = preyFAs[,c(2,3)]
#FC = FC \%>\%  arrange(Species)
#FC.vec = tapply(FC$lipid,FC$Species,mean,na.rm=TRUE)
#FC.red <- FC.vec[spec.red]

#test <- p.SMUFASA(predator.matrix, prey.red, FC.red, fa.set)

#test$Cal_Estimates

}
