% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_germplasm_attributes}
\alias{get_germplasm_attributes}
\title{Get germplasm attributes for a given germplasm in a crop}
\usage{
get_germplasm_attributes(germplasm_name = "")
}
\arguments{
\item{germplasm_name}{the name of the germplasm}
}
\value{
a data frame of the germplasm attributes
}
\description{
Get germplasm attributes for a given germplasm in a crop
}
\examples{
if(interactive()) {
# config your BMS connection
set_qbms_config("https://www.bms-uat-test.net/ibpworkbench")

# login using your BMS account (interactive mode)
# you can pass BMS username and password as parameters (batch mode)
login_bms()

set_crop("maize")

# select a breeding program by name
set_program("MC Maize")

# retrive attributes data of a given germplasm in a crop
germplasm_attributes <- get_germplasm_attributes("BASFCORN-2-1")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{get_germplasm_data}}
}
\author{
Johan Steven Aparicio, \email{j.aparicio@cgiar.org}
}
