% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALoD.R
\name{LogLikALoD}
\alias{LogLikALoD}
\title{Log-likelihood function for the quantile-based asymmetric logistic distribution.}
\usage{
LogLikALoD(y, mu, phi, alpha)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{mu}{This is the location parameter \eqn{\mu}.}

\item{phi}{This is the scale parameter  \eqn{\phi}.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.}
}
\value{
\code{\link{LogLikALoD}} provides the value of the Log-likelihood function of the quantile-based asymmetric logistic distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha)=\ln[L_n(\mu,\phi,\alpha)]}
in the quantile-based asymmetric logistic distribution is presented in Gijbels et al. (2019a).
}
\examples{
# Example
y<-rnorm(100)
LogLikALoD(y,mu=0,phi=1,alpha=0.5)

}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, to appear.
}
}
