% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pupil_data.R
\name{plot.Pupil_test_data}
\alias{plot.Pupil_test_data}
\title{Pre-prepared plots of PupillometryR data}
\usage{
\method{plot}{Pupil_test_data}(x, show_divergence = TRUE, colour = "black", fill = "grey", ...)
}
\arguments{
\item{x}{A Pupil_test_data dataframe}

\item{show_divergence}{logical indicating whether divergences are to be highlighted}

\item{colour}{string indicating colour of geom_line, passed to ggplot2}

\item{fill}{string indicating fill hue of divergence highlights, passed to ggplot2}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
The plot functions are designed to run with just data and pupil selections,
with some additional options for fun with plotting. To see these plots,
you must first use one of the run_functional tests.
}
\examples{
Sdata <- make_pupillometryr_data(data = pupil_data,
                               subject = ID,
                               trial = Trial,
                               time = Time,
                               condition = Type)
regressed_data <- regress_data(data = Sdata, pupil1 = RPupil, pupil2 = LPupil)
mean_data <- calculate_mean_pupil_size(data = regressed_data,
pupil1 = RPupil, pupil2 = LPupil)
base_data <- baseline_data(data = mean_data, pupil = mean_pupil, start = 0, stop = 100)
differences <- create_difference_data(data = base_data,
pupil = mean_pupil)
spline_data <- create_functional_data(data = differences, pupil = mean_pupil, basis = 10, order = 4)
ft_data <- run_functional_t_test(data = spline_data,
pupil = mean_pupil)
p <- plot(ft_data, show_divergence = TRUE, colour = 'red', fill = 'orange')
p
}
