% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_region_OC.R
\name{get_data_region_OC}
\alias{get_data_region_OC}
\title{Retrieve data from the OpenCoesione data base per region.}
\usage{
get_data_region_OC(
  cod_reg,
  cod_prov = NULL,
  cod_mun = NULL,
  start = NULL,
  end = NULL,
  geo_ref = NULL,
  soil_defense = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{cod_reg}{character. Vector specifying one or more region of interest. To get information about the codes associated to each region use the function \code{\link{get_info_OC}}}

\item{cod_prov}{character. The ISTAT province code is used to filter data based on one or more specific provinces of interest.(See \code{\link{get_codes}} function)}

\item{cod_mun}{character. The ISTAT municipality code is used to filter data based on one or more specific provinces of interest.(See \code{\link{get_codes}} function)}

\item{start}{(format YYYY-mm-dd). Effective starting date of the project. This date can be of interest for filtering and analyzing relevant data.}

\item{end}{(format YYYY-mm-dd). Effective ending date of the project. This date can be of interest for filtering and analyzing relevant data.}

\item{geo_ref}{character, The georeference data can be specified using the \code{geo_ref} argument. If set to \code{A}, the function returns shape polygons of each municipality. If set to \code{C}, it retrieves the coordinates of the centroids of each municipality.}

\item{soil_defense}{Logical.  By default set to \code{FALSE}. If only soil defense data are of interest set the argument to \code{TRUE}.}

\item{verbose}{Logic value (TRUE or FALSE). Toggle warnings and messages. If 'verbose = TRUE' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose = FALSE' any message about
the progression is suppressed.}
}
\value{
Object of classe \code{data.frame} showing 42 variables:
Descriptive Variables:
\itemize{
\item{Local Project Code (\code{character})}
\item{CUP (\code{character})}
\item{Intervention (\code{character})}
}

Financial Variables:
\itemize{
\item{EU Funding (\code{numeric})}
\item{FESR EU Funding (\code{numeric})}
\item{FSE EU Funding (\code{numeric})}
\item{FEASR EU Funding (\code{numeric})}
\item{FEAMP EU Funding (\code{numeric})}
\item{IOG EU Funding (\code{numeric})}
\item{Fondo di Rotazione ITA (\code{numeric})}
\item{FSC ITA Funding (\code{numeric})}
\item{PAC ITA Funding (\code{numeric})}
\item{Completamenti ITA Funding (\code{numeric})}
\item{Other Measures ITA Funding (\code{numeric})}
\item{Region Funding (\code{numeric})}
\item{Province Funding (\code{numeric})}
\item{Municipality Funding (\code{numeric})}
\item{Released Resources (\code{numeric})}
\item{Other Public Funding (\code{numeric})}
\item{Foreign State Funding (\code{numeric})}
\item{Private Funding (\code{numeric})}
\item{Total Public Funding (\code{numeric})}
\item{Total Funding (\code{numeric})}
}
Geographical References:
\itemize{
\item{DEN_REGION (\code{character})}
\item{DEN_PROVINCE (\code{character})}
\item{DEN_MUNICIPALITY (\code{character})}
\item{COD_REGION (\code{character})}
\item{COD_PROVINCE (\code{character})}
\item{COD_MUNICIPALITY (\code{character})}
\item{geom (\code{character})}
}

Legislative process main steps:
\itemize{
\item{Feasibility Study Starting Date (\code{character})}
\item{Feasibility Study Ending Date (\code{character})}
\item{Preliminary Design Starting Date (\code{character})}
\item{Preliminary Design Ending Date (\code{character})}
\item{Definitive Design Starting Date (\code{character})}
\item{Definitive Design Ending Date (\code{character})}
\item{Executive Design Starting Date (\code{character})}
\item{Executive Design Ending Date (\code{character})}
\item{Effective Design Starting Date (\code{character})}
\item{Effective Design Ending Date (\code{character})}
\item{Works Execution Starting Date (\code{character})}
\item{Works Execution Ending Date (\code{character})}
\item{Conclusion Starting Date (\code{character})}
\item{Conclusion Ending Date (\code{character})}
}
}
\description{
The \code{get_data_region_OC} function retrieves data from one or more Italian regions using associated region codes. It offers filtering options based on project start/end dates, province, and municipality codes. Additionally, it provides geospatial references.
}
\examples{
 dati_VDA <- get_data_region_OC("VDA", cod_mun = "007002")
 # #Retrieving data for the municipality with code 007002 in the Valle d'Aosta region.
}
\references{
\href{https://opencoesione.gov.it/en/dati/}{Open Coesione}
}
\author{
Lorena Ricciotti
}
