% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getter_functions.R
\name{AIDs-SIDs-CIDs}
\alias{AIDs-SIDs-CIDs}
\alias{AIDs}
\alias{CIDs}
\alias{SIDs}
\alias{AIDs.PubChemInstance_AIDs}
\alias{CIDs.PubChemInstance_CIDs}
\alias{SIDs.PubChemInstance_SIDs}
\title{Assay, Compound, and Substance Identifiers}
\usage{
AIDs(object, ...)

CIDs(object, ...)

SIDs(object, ...)

\method{AIDs}{PubChemInstance_AIDs}(object, .to.data.frame = TRUE, ...)

\method{CIDs}{PubChemInstance_CIDs}(object, .to.data.frame = TRUE, ...)

\method{SIDs}{PubChemInstance_SIDs}(object, .to.data.frame = TRUE, ...)
}
\arguments{
\item{object}{An object returned from a PubChem request, typically generated by functions such as \link{get_cids}, \link{get_aids},
and \link{get_sids}.}

\item{...}{Additional arguments passed to other methods. Currently, these arguments have no effect.}

\item{.to.data.frame}{a logical. If TRUE, returned object will be forced to be converted into a data.frame (or tibble).
If failed to convert into a data.frame, a list will be returned with a warning. Be careful for complicated lists
(i.e., many elements nested within each other) since it may be time consuming to convert such lists into a data frame.}
}
\description{
These functions are used to retrieve identification information for assays, substances, and compounds from the PubChem database.
}
\examples{
\donttest{
# Retrieve Assay IDs
aids <- get_aids(identifier = c("aspirin", "caffeine"), namespace = "name")
AIDs(aids)
}

\donttest{
# Compound IDs
cids <- get_cids(identifier = c("aspirin", "caffein"), namespace = "name")
CIDs(cids)
}

\donttest{
# Substance IDs
sids <- get_sids(identifier = c("aspirin", "caffein"), namespace = "name")
SIDs(sids)
}

}
