% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{get_plotMutInteract}
\alias{get_plotMutInteract}
\title{Exact tests to detect mutually exclusive, co-occuring and altered genesets or pathways.}
\usage{
get_plotMutInteract(
  module = NULL,
  genes = NULL,
  freq_matrix,
  pvalue = c(0.05, 0.01),
  returnAll = TRUE,
  fontSize = 0.8,
  showSigSymbols = TRUE,
  showCounts = FALSE,
  countStats = "all",
  countType = "all",
  countsFontSize = 0.8,
  countsFontColor = "black",
  colPal = "BrBG",
  nShiftSymbols = 5,
  sigSymbolsSize = 2,
  sigSymbolsFontSize = 0.9,
  pvSymbols = c(46, 42),
  limitColorBreaks = TRUE
)
}
\arguments{
\item{module}{The gene module,generated by `get_final_candidate_module`.}

\item{genes}{The modular gene,generated by `get_final_candidate_module`.}

\item{freq_matrix}{The mutations matrix,generated by `get_mut_status`.}

\item{pvalue, returnAll, fontSize, showSigSymbols, showCounts, countStats, countType, countsFontSize, countsFontColor, colPal, nShiftSymbols, sigSymbolsSize, sigSymbolsFontSize, pvSymbols, limitColorBreaks}{see \code{\link[pathwayTMB]{plotMutInteract}}}
}
\value{
No return value
}
\description{
Performs Pair-wise Fisher's Exact test to detect mutually exclusive or co-occuring events.
}
\examples{
\donttest{#load the data.
data(plotMutInteract_moduledata,plotMutInteract_mutdata)
#draw an plotMutInteract of genes
get_plotMutInteract(genes=unique(unlist(plotMutInteract_moduledata)),
freq_matrix=plotMutInteract_mutdata)
#draw an plotMutInteract of modules
get_plotMutInteract(module=plotMutInteract_moduledata,
freq_matrix=plotMutInteract_mutdata)}
}
