% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covls.R
\name{print.procmod_varls}
\alias{print.procmod_varls}
\title{Print procrustean Variance / Covariance Matrix.}
\usage{
\method{print}{procmod_varls}(x, ...)
}
\arguments{
\item{x}{a \code{procmod_varls}
object}

\item{...}{other parameters passed to other functions}
}
\description{
Print procrustean Variance / Covariance Matrix.
}
\examples{
# Build Three matrices of 3 rows.
A <- simulate_matrix(10,3)
B <- simulate_matrix(10,5)
C <- simulate_correlation(B,10,r2=0.6)

# Computes the variance covariance matrix
data <- procmod_frame(A = A, B = B, C = C)
v <- varls(data, nrand = 100)

print(v)

}
\seealso{
\code{\link[ProcMod]{varls}}
}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
