% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_extraction.R
\name{seq2feature_mds}
\alias{seq2feature_mds}
\title{Feature extraction via multidimensional scaling}
\usage{
seq2feature_mds(seqs = NULL, K = 2, method = "auto",
  dist_type = "oss_action", pca = TRUE, subset_size = 100,
  subset_method = "random", n_cand = 10, return_dist = FALSE,
  seed = 12345, L_set = 1:3)
}
\arguments{
\item{seqs}{a \code{"\link{proc}"} object or a square matrix. If a squared matrix is 
provided, it is treated as the dissimilary matrix of a group of response processes.}

\item{K}{the number of features to be extracted.}

\item{method}{a character string specifies the algorithm used for performing MDS. See
'Details'.}

\item{dist_type}{a character string specifies the dissimilarity measure for two
response processes. See 'Details'.}

\item{pca}{logical. If \code{TRUE} (default), the principal components of the
extracted features are returned.}

\item{subset_size, n_cand}{two parameters used in the large data algorithm. See 'Details'
and \code{\link{seq2feature_mds_large}}.}

\item{subset_method}{a character string specifying the method for choosing the subset 
in the large data algorithm. See 'Details' and \code{\link{seq2feature_mds_large}}.}

\item{return_dist}{logical. If \code{TRUE}, the dissimilarity matrix will be
returned. Default is \code{FALSE}.}

\item{seed}{random seed.}

\item{L_set}{length of ngrams considered}
}
\value{
\code{seq2feature_mds} returns a list containing 
  \item{theta}{a numeric matrix giving the \code{K} extracted features or principal
    features. Each column is a feature.} 
  \item{dist_mat}{the dissimilary matrix. This element exists only if 
    \code{return_dist=TRUE}.}
}
\description{
\code{seq2feature_mds} extracts \code{K} features from response processes by
multidimensional scaling.
}
\details{
Since the classical MDS has a computational complexity of order \eqn{n^3} where 
\eqn{n} is the number of response processes, it is computational expensive to 
perform classical MDS when a large number of response processes is considered. 
In addition, storing an \eqn{n \times n} dissimilarity matrix when \eqn{n} is large
require a large amount of memory. In \code{seq2feature_mds}, the algorithm proposed
in Paradis (2018) is implemented to obtain MDS for large datasets. \code{method} 
specifies the algorithm to be used for obtaining MDS features. If \code{method = "small"},
classical MDS is used by calling \code{\link{cmdscale}}. If \code{method = "large"},
the algorithm for large datasets will be used. If \code{method = "auto"} (default), 
\code{seq2feature_mds} selects the algorithm automatically based on the sample size.

\code{dist_type} specifies the dissimilarity to be used for measuring the discrepancy
between two response processes. If \code{dist_type = "oss_action"}, the order-based 
sequence similarity (oss) proposed in Gomez-Alonso and Valls (2008) is used 
for action sequences. If \code{dist_type = "oss_both"}, both action sequences and
timestamp sequences are used to compute a time-weighted oss. 
  
The number of
features to be extracted \code{K} can be selected by cross-validation using
\code{\link{chooseK_mds}}.
}
\examples{
n <- 50
seqs <- seq_gen(n)
theta <- seq2feature_mds(seqs, 5)$theta
}
\references{
Gomez-Alonso, C. and Valls, A. (2008). A similarity measure for sequences of
  categorical data based on the ordering of common elements. In V. Torra & Y. Narukawa (Eds.) 
  \emph{Modeling Decisions for Artificial Intelligence}, (pp. 134-145). Springer Berlin Heidelberg.

Paradis, E. (2018). Multidimensional scaling with very large datasets. \emph{
  Journal of Computational and Graphical Statistics}, 27(4), 935-939.
}
\seealso{
\code{\link{chooseK_mds}} for choosing \code{K}.

Other feature extraction methods: \code{\link{aseq2feature_seq2seq}},
  \code{\link{atseq2feature_seq2seq}},
  \code{\link{seq2feature_mds_large}},
  \code{\link{seq2feature_seq2seq}},
  \code{\link{tseq2feature_seq2seq}}
}
\concept{feature extraction methods}
