% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_personal_explanations_votes.R
\name{get_recent_personal_explanations_votes}
\alias{get_recent_personal_explanations_votes}
\title{Get Recent Personal Explanation Votes}
\usage{
get_recent_personal_explanations_votes(congress, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{101-116}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent personal explanation votes in the specified Congress, contains explanations parsed to individual votes and have an additional category attribute describing the general reason for the absence or incorrect vote.
}
\description{
Lawmakers, mostly in the House but also in the Senate, can make personal explanations for missed or mistaken votes in the Congressional Record. Unlike the “Recent Personal Explanations” response, this response contains explanations parsed to individual votes and have an additional category attribute describing the general reason for the absence or incorrect vote. To get lists of recent personal explanation votes, use the following URI structure. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/explanations/votes.json
}
\examples{
\dontrun{
get_recent_personal_explanations_votes(114)
}
}
