% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_independent_expenditure_by_committee.R
\name{get_independent_expenditure_by_committee}
\alias{get_independent_expenditure_by_committee}
\title{Get Independent Expenditures by Specific Committee}
\usage{
get_independent_expenditure_by_committee(
  cycle = 2018,
  FEC_ID,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{cycle}{The election cycle}

\item{FEC_ID}{The FEC-assigned 9-character ID of a committee. To find a committee official FEC ID, use a candidate search request or the FEC web site.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent independent expenditures by a given committee.
}
\description{
#HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/committees/{fec-id}/independent_expenditures
}
\examples{
\dontrun{
get_independent_expenditure_by_committee(2016, FEC_ID ='C00575423')
}
}
