% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_congressional_statement_by_bill.R
\name{get_congressional_statement_by_bill}
\alias{get_congressional_statement_by_bill}
\title{Get Congressional Statements by Bill}
\usage{
get_congressional_statement_by_bill(congress, bill_id, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{113-116}

\item{bill_id}{a bill slug, for example s19 - these can be found in bill responses.}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results and supports pagination using multiples of 20.
}
\description{
To get lists of statements published on a specific member’s congressional website during a particular congress, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/bills/{bill-id}/statements.json
}
\examples{
\donttest{
get_congressional_statement_by_bill(115, 's19')
}
}
