% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{price_index}
\alias{price_index}
\title{A general function to compute a price index}
\usage{
price_index(
  data,
  start,
  end,
  formula = "fisher",
  window = 13,
  splice = "movement",
  base = start,
  sigma = 0.7,
  interval = FALSE
)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric) and \code{prodID} (as numeric, factor or character). A column \code{quantities} (as positive numeric) is also essential even if the selected index is an unweighted formula (unit values are calculated).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2019-12".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{formula}{The character string indicating the price index formula is to be calculated. To see available options please use the link: \code{\link{PriceIndices}}.}

\item{window}{The length of the time window if the multilateral index is selected (as positive integer: typically multilateral methods are based on the 13-month time window).}

\item{splice}{A character string indicating the splicing method (if the multilateral splicing index is selected). Available options are: "movement", "window","half","mean" and their additional variants: "window_published", "half_published" and "mean_published".}

\item{base}{The prior period used in the Young- or Lowe-type price indices (as character) limited to the year and month, e.g. "2020-01".}

\item{sigma}{The elasticity of substitution parameter used in the Lloyed-Moulton and AG Mean indices (as numeric).}

\item{interval}{A logical value indicating whether the function is to provide the price index comparing the research period defined by \code{end} to the base period defined by \code{start} (then \code{interval} is set to FALSE) or all fixed base indices are to be presented (the fixed base month is defined by \code{start}).}
}
\value{
This function returns a value or values of the selected price index. If the \code{interval} parameter is set to TRUE then it returns a data frame with two columns: dates and index values. The function does not take into account aggregating over outlets or product subgroups (to consider these types of aggregating, please use the \code{\link{final_index}} or the \code{\link{final_index2}} function).
}
\description{
This function returns a value or values of the selected price index.
}
\examples{
\donttest{price_index(milk, start="2018-12", end="2020-02",formula="walsh",interval=FALSE)}
\donttest{price_index(milk, start="2018-12",end="2020-02",formula="tpd_splice",
splice="half",interval=TRUE)}
}
