% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScientSDI.R
\name{ScientSDI}
\alias{ScientSDI}
\title{Estimate parameters of Gamma, Generalized Extreme Value, or Generalized Logistic Distributions}
\usage{
ScientSDI(
  lon,
  lat,
  start.date,
  end.date,
  distr = "GEV",
  TS = 4L,
  Good = "No",
  sig.level = 0.95,
  RainUplim = NULL,
  RainLowlim = NULL,
  PEUplim = NULL,
  PELowlim = NULL
)
}
\arguments{
\item{lon}{longitude in decimal degrees: (+) Eastern Hemisphere, (-) Western Hemisphere.}

\item{lat}{latitude in decimal degrees: (+) Northern hemisphere, (-) Southern
Hemisphere.}

\item{start.date}{date at which the indices estimates should start. Format:
\dQuote{YYYY-MM-DD}.}

\item{end.date}{date at which the indices estimates should end. Format: \dQuote{YYYY-MM-DD}.}

\item{distr}{A character variable (\dQuote{GEV} or \dQuote{GLO}) defining the distribution
to calculate the \acronym{SPEI}.  Default is \code{GEV}.}

\item{TS}{Time scale on the quart.month basis (integer values between 1 and 96).
Default is 4.}

\item{Good}{A character variable ("Yes" or "No") to calculate or not the goodness-of-fit
and normality tests. Default is "No".}

\item{sig.level}{A numeric variable (between 0.90 and 0.95) defining the significance level
for parameter Good. Default is "0.95".}

\item{RainUplim}{Optional. Upper limit in millimetres from which rainfall values larger than
it will be removed.  Default is \code{NULL}.}

\item{RainLowlim}{Optional. Lower limit in millimetres from which rainfall values smaller than
it will be removed.  Default is \code{NULL}.}

\item{PEUplim}{Optional. Upper limit in millimetres from which evapotranspiration values
larger than it will be removed.  Default is \code{NULL}.}

\item{PELowlim}{Optional. Lower limit in millimetres from which evapotranspiration values
smaller than it will be removed.  Default is \code{NULL}.}
}
\value{
A \code{list} object with data calculated at the time scale selected by the
   user.  If \code{Good = "Yes"}, this \code{list} object includes:
\describe{
  \item{SDI}{The \dQuote{NASA-SPI}, \dQuote{NASA-SPEI.HS} and
    \dQuote{NASA-SPEI.PM.}}
  \item{DistPar}{The parameters of the distributions (gamma and
    \acronym{GEV}) used to calculate the indices.}
  \item{GoodFit}{The Lilliefors and Anderson-Darling tests goodness-of-fit
    tests.}
  \item{Normality}{The outcomes of the two normality checking procedures (Wu
    \emph{et al}., 2006 and Stagge \emph{et al}., 2015).}
 }

If \code{Good = "No"}, this \code{list} object includes \acronym{SDI} and
  DistPar.

This function also presents other data (in millimiters) calculated from the
  \acronym{NASA} \acronym{POWER} project:
\itemize{
  \item Rainfall amounts (Rain),
  \item potential evapotranspiration values estimated through the Hargreaves
   and Samani method (\acronym{PEHS}),
  \item potential evapotranspiration values estimated through the FAO-56
   Penman-Monteith method (\acronym{PEPM}), and
  \item the difference between rainfall and potential evapotranspiration
  (\acronym{PPEHS} and \acronym{PPEPM}).
  }
}
\description{
Verifies concepts expected from SDI.  The first step of the \acronym{SPI} and
  \acronym{SPEI} algorithms is to calculate the cumulative probabilities of
  their input variables (Guttman 1999).  Function estimates the parameters of
  the gamma, generalized extreme value (GEV), or generalized logistic
  distributions (GLO) through the L-moments method are provided.  This
  function also allows users to remove suspicious values from the data
  sample.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# This example requires an Internet connection to fetch data and takes >5s
#  to run, and so is only run in interactive sessions

ScientSDI(
  lon = -47.3,
  lat = -22.87,
  start.date = "1993-01-01",
  end.date = "2022-12-31",
  TS = 1,
  Good = "no"
)
\dontshow{\}) # examplesIf}
}
\references{
Guttman, N.B., 1999. Accepting the standardized precipitation
   index: a calculation algorithm 1. JAWRA Journal of the American Water
   Resources Association, 35(2), pp.311-322.

 Stagge, J.H., Tallaksen, L.M., Gudmundsson, L., Van Loon, A.F. and Stahl,
   K., 2015. Candidate distributions for climatological drought indices (SPI
   and SPEI). International Journal of Climatology, 35(13), pp.4027-4040.

 Wu, H., Svoboda, M.D., Hayes, M.J., Wilhite, D.A. and Wen, F., 2006.
  Appropriate application of the standardized precipitation index in arid
  locations and dry seasons. International Journal of Climatology: A Journal
  of the Royal Meteorological Society, 27(1), pp.65-79.
}
