% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoweREST_subset.R
\name{PoweREST_subset}
\alias{PoweREST_subset}
\title{Bootstrap resampling and power calculation for a subset of genes}
\usage{
PoweREST_subset(Seurat_obj,cond,replicates=1,spots_num,
iteration=100,random_seed=1,pvalue=0.05,logfc.threshold = 0.1,
min.pct = 0.01,...)
}
\arguments{
\item{Seurat_obj}{A \href{https://CRAN.R-project.org/package=Seurat}{Seurat} object.}

\item{cond}{The name of the variable that indicates different conditions which is also stored in the
meta.data of the Seurat_obj and should be in character type.}

\item{replicates}{The number of sample replicates per group.}

\item{spots_num}{The number of spots per replicate.}

\item{iteration}{The number of iterations of the resampling.}

\item{random_seed}{To set a random seed.}

\item{pvalue}{The pvalue that will be considered significant.}

\item{logfc.threshold}{For every resampling, limit testing to genes which show, on average, at least X-fold difference (log-scale) between the two groups.
Default is 0.1 Increasing logfc.threshold speeds up the function, but can miss weaker signals.}

\item{min.pct}{For every resampling, only test genes that are detected in a minimum fraction of min.pct spots in either of the two populations.
Meant to speed up the function by not testing genes that are very infrequently expressed. Default is 0.01.}

\item{...}{DE test to use other than the default Wilcoxon test.}
}
\value{
A list of values containing the power, average log2FC and percentage of spots detecting the gene among
the resampling data, the replicate value and the spots number per slice specified by the user and the filtered.
}
\description{
This function performs bootstrap resampling upon a Seurat subject under each condition
to resemble the real dataset which allows the exact power calculation, and perform DE analysis.
Similar to 'PoweREST', users can specify the test they would like to perform for the DE analysis
in '...' (more test options can be refered to \href{https://CRAN.R-project.org/package=Seurat}{Seurat}.
Different to 'PoweREST', users can specify the values of 'min.pct' and 'logfc.threshold'
to pre-filter the genes based on their minimum detection rate 'min.pct' and at least X-fold difference (log-scale)
('logfc.threshold') across both groups. But this kind of filtering can miss weaker signals.
}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
