% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{wf_sweep_tabular}
\alias{wf_sweep_tabular}
\title{Walk-forward sweep of tabular configs (window-wise distribution of metrics)}
\usage{
wf_sweep_tabular(
  features_list,
  labels,
  prices,
  fit_fn,
  predict_fn,
  schedule = list(is = 104L, oos = 4L, step = 4L),
  grid = list(top_k = c(10L, 15L), temperature = c(8, 12), method = c("softmax", "rank"),
    transform = c("zscore")),
  caps = list(max_per_symbol = 0.08, max_per_group = NULL),
  group_map = NULL,
  freq = 52,
  cost_bps = 0,
  max_windows = NULL,
  ic_method = "spearman"
)
}
\arguments{
\item{features_list}{List of feature panels.}

\item{labels}{Label panel.}

\item{prices}{Price panel for backtests.}

\item{fit_fn, predict_fn}{Model fit and predict functions.}

\item{schedule}{List with elements is, oos, step.}

\item{grid}{Named list of parameter vectors to sweep (e.g., top_k, temperature, method, transform).}

\item{caps}{Exposure caps (e.g., max_per_symbol/max_per_group).}

\item{group_map}{Optional Symbol->Group mapping for group caps/selection.}

\item{freq}{Compounding frequency for annualization (e.g., 52 for weekly).}

\item{cost_bps}{One-way trading cost in basis points (applied on rebalance).}

\item{max_windows}{optional limit for speed.}

\item{ic_method}{IC method ('spearman' or 'pearson').}
}
\value{
data.table with medians/means across OOS windows.
}
\description{
Walk-forward sweep of tabular configs (window-wise distribution of metrics)
}
