% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{vol_target}
\alias{vol_target}
\title{Volatility targeting (row-wise) with optional down-only cap}
\usage{
vol_target(
  weights,
  prices,
  lookback = 26L,
  target_annual = 0.12,
  periods_per_year = 52L,
  cap = TRUE
)
}
\arguments{
\item{weights}{data.frame/data.table with columns: \code{Date}, then one column per symbol.}

\item{prices}{data.frame/data.table of adjusted prices at the same cadence as \code{weights}:
first column \code{Date}, remaining columns one per symbol (matching weight symbols).}

\item{lookback}{Integer window length (in periods) for the rolling covariance. Default 26.}

\item{target_annual}{Annualised volatility target (e.g., 0.12 for 12\%). Must be > 0.}

\item{periods_per_year}{Number of periods per year used for annualisation (e.g., 52 for weekly).}

\item{cap}{If TRUE (default), scale down only: exposure is reduced when the
estimated vol exceeds the target, and untouched otherwise. In this down-only mode,
the function adds/overwrites a \code{CASH} column equal to
\code{1 - rowSums(pmax(scaled_weights, 0))} so that symbols + CASH is approximately 1.
If FALSE, the scaler may be > 1 (leverage allowed) and no \code{CASH} is added.}
}
\value{
A \code{data.table} with the same \code{Date} and symbol columns as \code{weights}
(plus \code{CASH} when \code{cap = TRUE}).
}
\description{
Scales each row of a wide weight table (\code{Date + symbols}) so the estimated
annualised portfolio volatility matches a target. Volatility is estimated
from a rolling covariance of simple asset returns computed from \code{prices}.
}
\details{
Weights decided at t-1 apply to returns over t.

The covariance at row i is computed from the last \code{lookback} rows of simple
returns up to i (inclusive), estimated on the intersection of symbols present
in both \code{weights} and \code{prices}. The row scaler is
\code{s_i = min(1, target_vol / est_vol_i)} when \code{cap = TRUE}, and
\code{s_i = target_vol / est_vol_i} when \code{cap = FALSE}, with safeguards for zero or
non-finite variances.
}
\examples{
\donttest{
  data(sample_prices_weekly)
  mom12 <- PortfolioTesteR::calc_momentum(sample_prices_weekly, 12)
  sel10 <- PortfolioTesteR::filter_top_n(mom12, 10)
  w_eq  <- PortfolioTesteR::weight_equally(sel10)

  w_vt  <- vol_target(w_eq, sample_prices_weekly, lookback = 26,
                      target_annual = 0.12, periods_per_year = 52, cap = TRUE)
  head(w_vt)
}

}
