% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{combine_filters}
\alias{combine_filters}
\title{Combine Multiple Filter Conditions}
\usage{
combine_filters(..., op = "and", apply_when = NULL, debug = FALSE)
}
\arguments{
\item{...}{Two or more filter data frames to combine}

\item{op}{Operation: "and" or "or"}

\item{apply_when}{Optional condition vector for conditional filtering}

\item{debug}{Print debug information (default: FALSE)}
}
\value{
Combined binary selection matrix
}
\description{
Combines multiple filter conditions using AND or OR logic.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, 12)
rsi <- calc_rsi(sample_prices_weekly, 14)
# Create individual filters
high_momentum <- filter_above(momentum, 0.05)
moderate_rsi <- filter_between(rsi, 40, 60)
# Combine them
combined <- combine_filters(high_momentum, moderate_rsi, op = "and")
}
