% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_volatility}
\alias{weight_by_volatility}
\title{Volatility-Based Portfolio Weighting}
\usage{
weight_by_volatility(
  selected_df,
  vol_timeframe_data,
  strategy_timeframe_data = NULL,
  lookback_periods = 26,
  low_vol_preference = TRUE,
  vol_method = "std",
  weighting_method = c("rank", "equal", "inverse_variance")
)
}
\arguments{
\item{selected_df}{Binary selection matrix (1 = selected, 0 = not)}

\item{vol_timeframe_data}{Price data for volatility calculation (usually daily)}

\item{strategy_timeframe_data}{Price data matching strategy frequency}

\item{lookback_periods}{Number of periods for volatility (default: 26)}

\item{low_vol_preference}{TRUE = lower vol gets higher weight (default: TRUE)}

\item{vol_method}{"std", "range", "mad", or "abs_return"}

\item{weighting_method}{"rank", "equal", or "inverse_variance"}
}
\value{
Data.table with volatility-based weights
}
\description{
Weights securities based on their volatility characteristics.
Can prefer low-volatility (defensive) or high-volatility (aggressive) stocks.
}
\examples{
data("sample_prices_weekly")
data("sample_prices_daily")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, 10)
daily_vol <- calc_rolling_volatility(sample_prices_daily, lookback = 252)
aligned_vol <- align_to_timeframe(daily_vol, sample_prices_weekly$Date)
weights <- weight_by_volatility(selected, aligned_vol, low_vol_preference = TRUE)
}
