% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Doptim.R
\name{calc_autofocus}
\alias{calc_autofocus}
\title{Compute the autofocus portion of the stochastic gradient routine}
\usage{
calc_autofocus(
  m,
  ni_var,
  dmf,
  varopt,
  varopto,
  maxvar,
  minvar,
  gradvar,
  normgvar,
  avar,
  model_switch,
  groupsize,
  xtopt,
  xopt,
  aopt,
  ni,
  bpop,
  d,
  sigma,
  docc,
  poped.db
)
}
\arguments{
\item{m}{Number of groups in the study.  Each individual in a group will have the same design.}

\item{ni_var}{The ni_var.}

\item{dmf}{The initial OFV. If set to zero then it is computed.}

\item{varopt}{The varopt.}

\item{varopto}{The varopto.}

\item{maxvar}{The maxvar.}

\item{minvar}{The minvar.}

\item{gradvar}{The gradvar.}

\item{normgvar}{The normgvar.}

\item{avar}{The avar.}

\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{groupsize}{A vector of the number of individuals in each group.}

\item{xtopt}{The optimal sampling times matrix.}

\item{xopt}{The optimal discrete design variables matrix.}

\item{aopt}{The optimal continuous design variables matrix.}

\item{ni}{A vector of the number of samples in each group.}

\item{bpop}{Matrix defining the fixed effects, per row (row number = parameter_number) we should have:
\itemize{
\item column 1 the type of the distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform,
 3 = User Defined Distribution, 4 = lognormal and 5 = truncated normal)
\item column 2  defines the mean.
\item column 3 defines the variance of the distribution (or length of uniform distribution).
}
Can also just supply the parameter values as a vector \code{c()} if no uncertainty around the 
parameter value is to be used. The parameter order of  'bpop' is defined in the 'fg_fun' or 'fg_file'. If you use named 
arguments in 'bpop' then the order will be worked out automatically.}

\item{d}{Matrix defining the diagonals of the IIV (same logic as for the fixed effects 
matrix bpop to define uncertainty). One can also just supply the parameter values as a \code{c()}. 
The parameter order of 'd' is defined in the 'fg_fun' or 'fg_file'. If you use named 
arguments in 'd' then the order will be worked out automatically.}

\item{sigma}{Matrix defining the variances can covariances of the residual variability terms of the model.
can also just supply the diagonal parameter values (variances) as a \code{c()}.}

\item{docc}{Matrix defining the IOV, the IOV variances and the IOV distribution as for d and bpop.}

\item{poped.db}{A PopED database.}
}
\value{
A list containing:
\item{navar}{The autofocus parameter.}
\item{poped.db}{PopED database.}
}
\description{
Compute the autofocus portion of the stochastic gradient routine
}
\examples{
library(PopED)

############# START #################
## Create PopED database
## (warfarin model for optimization)
#####################################

## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error  
## to avoid sample times at very low concentrations (time 0 or very late samples).

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_fun=ff.PK.1.comp.oral.sd.CL,
                                  fg_fun=sfg,
                                  fError_fun=feps.add.prop,
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(prop=0.01,add=0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0.01,
                                  maxxt=120,
                                  a=c(DOSE=70),
                                  mina=c(DOSE=0.01),
                                  maxa=c(DOSE=100))

############# END ###################
## Create PopED database
## (warfarin model for optimization)
#####################################


\dontrun{
  
# Stochastic gradient search, DOSE and sample time optimization
sg.output <- poped_optimize(poped.db,opt_xt=1,opt_a=1, 
                            bUseRandomSearch= 0,
                            bUseStochasticGradient = 1,
                            bUseBFGSMinimizer = 0,
                            bUseLineSearch = 0,
                            sgit=20)

}
}
\seealso{
Other Optimize: 
\code{\link{Doptim}()},
\code{\link{LEDoptim}()},
\code{\link{RS_opt}()},
\code{\link{a_line_search}()},
\code{\link{bfgsb_min}()},
\code{\link{calc_ofv_and_grad}()},
\code{\link{mfea}()},
\code{\link{optim_ARS}()},
\code{\link{optim_LS}()},
\code{\link{poped_optim_1}()},
\code{\link{poped_optim_2}()},
\code{\link{poped_optim_3}()},
\code{\link{poped_optimize}()},
\code{\link{poped_optim}()}
}
\concept{Optimize}
\keyword{internal}
