% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{read.SATlotyper.output}
\alias{read.SATlotyper.output}
\title{read the haplotyping results from the SATlotyper output}
\usage{
read.SATlotyper.output(fname, output="", allelecodes=c("A", "B"),
sep, haploblockname="")
}
\arguments{
\item{fname}{filename of an xml file produced by SATlotyper}

\item{output}{character vector, console output of SATlotyper;
this contains a table of calculated haplotypes with more info
than the xml file}

\item{allelecodes}{the codes used for the ref and alt SNP alleles in
make.SATlotyper.input, default "A" and "B"}

\item{sep}{the separator used in make.SATlotyper.input (SATlotyper cleverly
identifies this separator and uses it for its output), default tab}

\item{haploblockname}{if not "" (default) the haplotype IDs are given as
<haploblockname>_<hapnr>, else just as <hapnr>, left_padded with zeroes}
}
\value{
a list with 3 items: \cr
$hapdos is a matrix with individuals in columns and haplotypes in rows,
giving the dosages of the haplotypes in each individual (summing to ploidy).
This is the same format as the hapdos components of the inferHaplotypes
results of PolyHaplotyper \cr
$haplotype.info is a data.frame that is a combination of information from two
or three tables:\cr
columns Haplotype and necessity are from element
haplotypings[[1]]$haplotypes in the xml file, \cr
column hapnr gives the PolyHaplotyper equivalents of the Haplotypes, \cr
column score is from element bootstrapping in the xml file, \cr
columns id, number, frequency, homozygous, necessary, distance and
neighbours are from (the console) output if present. \cr
The haplotype.info data.frame is ordered by hapnr. \cr
$HaplotypingScore is the single number in $haplotyping[[1]]$score.
}
\description{
read the haplotyping results from the SATlotyper output
}
\details{
The xml file is parsed using the package XML. The resulting list has
3 items named source, bootstrapping and haplotyping. In this function source is
ignored and the results are obtained from haplotypings[[1]] (i.e. even if multiple
haplotypings were done only the first is extracted), with the haplotype
score from the bootstrapping item added to the haplotype.info.
}
