% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_plot_metrics.R
\name{AntibodyForests_plot_metrics}
\alias{AntibodyForests_plot_metrics}
\title{Plots the resulting node metrics from the AntibodyForests_metrics function}
\usage{
AntibodyForests_plot_metrics(
  trees,
  plot.format,
  metrics.to.plot,
  group.by,
  max.groups,
  specific.groups,
  sample.by,
  features
)
}
\arguments{
\item{trees}{nested list of AntibodyForests objects or single object, as obtained from the AntibodyForests function.}

\item{plot.format}{string - 'violin' for violin plots of node metrics per feature (as determined by the feature parameter), or 'pca' for performing PCA on the node metrics dataframe.}

\item{metrics.to.plot}{vector of strings - the metrics to be plotted from the metrics dataframe (must be already calculated using the AntibodyForests_metrics function)}

\item{group.by}{string - whether to group the violin/scatter plots by additional features (e.g., group.by = 'sample_id' to get violin plots per feature, per each unique sample).}

\item{max.groups}{integer - maximum number of groups to be considered in the resulting plots if group.by is not NULL.}

\item{specific.groups}{vector of strings - specific groups to plot if group.by is not NULL.}

\item{sample.by}{string - additional grouping factor (e.g., group.by can be set to 'clonotype_id' and sample.by to 'sample_id' for plots grouped by both clonotypes and samples)}

\item{features}{string - will determine the point colors in the PCA scatterplot.}
}
\value{
either a violin plot or a scatter plot of the node metrics, as specified in the plot.format parameter
}
\description{
Will plot the resulting node metrics from the AntibodyForests_metrics function either as violin plots (plot.format = 'violin' or as a scatter plot of the principal components of the metrics dataframe - as long as multiple node metrics are calculated per node).
Requires the AntibodyForests_plot_metrics to be called before (as this function uses the resulting node_metrics dataframes).
}
\examples{
\dontrun{
AntibodyForests_plot_metrics(trees,
plot.format = 'violin', metrics.to.plot = 'degree',
group.by = 'sample_id', sample.by = NULL)
}
}
