% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_communities.R
\name{AntibodyForests_communities}
\alias{AntibodyForests_communities}
\title{Network clustering/community detection for the AntibodyForests similarity networks}
\usage{
AntibodyForests_communities(
  trees,
  VGM,
  community.algorithm,
  graph.type,
  which.bipartite,
  features,
  count.level,
  additional.parameters
)
}
\arguments{
\item{trees}{AntibodyForests object/list of AntibodyForests objects - the resulting sequence similarity or minimum spanning tree networks from the AntibodyForests function}

\item{VGM}{VGM object - for annotating the VGM object with the resulting clusters/communities.}

\item{community.algorithm}{string - denotes the community/clustering algorithm to be used. Several options are available: 'louvain', 'walktrap', 'edge_betweenness', 'fast_greedy', 'label_prop', 'leading_eigen', 'optimal', 'spinglass'.}

\item{graph.type}{string - the graph type available in the AntibodyForests object which will be used as the function input.
Currently supported network/analysis types: 'tree' (for the minimum spanning trees or sequence similarity networks obtained from the main AntibodyForests function), 'heterogeneous' for the bipartite graphs obtained via AntibodyForests_heterogeneous, 'dynamic' for the dynamic networks obtained from AntibodyForests_dynamics.}

\item{which.bipartite}{string - whether to perform clustering on the cell layer of the bipartite/heterogeneous graph ('cells'), sequence layer ('sequences') or on both ('both').}

\item{features}{vector of strings - features to be considered in the output bar plots (of feature counts per cluster). These features must be integrated when creating the initial AntibodyForests objects by using the node.features parameter.}

\item{count.level}{string - whether to consider cells ('cells') or sequences ('sequences') when counting the unique feature values in the output bar plots. When counting by sequences/nodes, each unique node is assigned the feature value of the majority of its consituent cells.}

\item{additional.parameters}{named list - additional parameters to be considered in the clustering algorithm, as mentioned in the igraph documentation for the respective algorithms (e.g., additional.parameters = list(resolution = 0.25)).}
}
\value{
a single AntibodyForests object or a nested list of AntibodyForests objects (depending on the input type) with community/cluster annotations as a vertex attribute. Additional bar plots of feature counts per resulting cluster are also displayed.
}
\description{
Performs community detection/clustering on the AntibodyForests sequence similarity networks. Annotates the resulting networks with a new igraph vertex attribute ('community') for downstream analysis or plotting. Can also add these annotations back to the VGM.
}
\examples{
\dontrun{
AntibodyForests_communities(trees = AntibodyForests_object,
VGM = NULL, community.algorithm = 'louvain',
graph.type = 'tree', features = 'seurat_clusters',
count.level = 'cells', additional.parameters = list(resolution = 0.25))
}
}
\seealso{
AntibodyForests, AntibodyForests_plot
}
