% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_overlay_clones.R
\name{VDJ_GEX_overlay_clones}
\alias{VDJ_GEX_overlay_clones}
\title{Highlights the cells belonging to any number of top clonotypes or of specifically selected clonotypes from one or more samples or groups in a GEX dimensional reduction.}
\usage{
VDJ_GEX_overlay_clones(
  GEX,
  reduction,
  n.clones,
  clones.to.plot,
  by.sample,
  by.other.group,
  ncol.facet,
  pt.size,
  clone.colors,
  split.plot.and.legend,
  platypus.version
)
}
\arguments{
\item{GEX}{A single seurat object from VDJ_GEX_matrix, which also includes VDJ information in the metadata (set integrate.VDJ.to.GEX to TRUE in the VDJ_GEX_matrix function) (VDJ_GEX_matrix.output[[2]])}

\item{reduction}{Character. Defaults to "umap". Name of the reduction to overlay clones on. Can be "pca", "umap", "tsne"}

\item{n.clones}{Integer. Defaults to 5. To PLOT TOP N CLONES. Number of Top clones to plot. If either by.sample or by.group is TRUE, n.clones clones from each sample or group will be overlayed}

\item{clones.to.plot}{Character. Alternative to n.clones. TO PLOT SPECIFIC CLONES. Must reference a column in the GEX@meta.data filled with TRUE and FALSE. Entries with TRUE label are plotted. Such a column may be generated using GEX@metadata$clones_to_plot_column <- GEX@metadata$Some_cell_identifier == "Interesting"}

\item{by.sample}{Boolean. Defaults to FALSE. Whether to overlay clones by sample. If set to TRUE this will generate a facet_wrap plot with as many facets as samples.}

\item{by.other.group}{Character string. Defaults to "none". Must be a valid column name of the metadata of the input seurat object. If so, this will generate a facet_wrap plot with as many facets unique entries in the specified column. This may be useful to plot cell type specific clones}

\item{ncol.facet}{Integer. Defaults to 2. Number of columns in the facet_wrap plot if by.sample or by.group is TRUE}

\item{pt.size}{Numeric. Defaults to 1. Size of points in DimPlot. Passed to Seurat::DimPlot}

\item{clone.colors}{Character vector. Defaults to rainbow(n.clones). Colors to use for individual clones. One can provide either a vector of length n.clones or a of length Nr. of samples/groups \* n.clones. In case that a vector of length n.clones is provided and by.group or by.sample is TRUE, colors are repeated for each sample/group}

\item{split.plot.and.legend}{Boolean. Defaults to FALSE. Whether to return the plot and the legend separately as a list. This can be useful if legends get large and distort the actual plots. The packages gridExtra and cowplot are required for this. If set to TRUE a list is returned where out[[1]] is the plot which can be printed just by executing out[[1]]; out[[2]] is the legend, which can be printed either using plot(out[[2]]) or grid.arrange(out[[2]])}

\item{platypus.version}{Character. At the moment this function runs only on the output of the VDJ_GEX_matrix function meaning that it is exclusively part of Platypus "v3". With further updates the functionality will be extended.}
}
\value{
A ggplot object or a list of a ggplot and a gtable legend (if split.plot.and.legend \=\= TRUE). Theme, colors etc. may be changed directly by adding new elements to this output (e.g. out \+ theme_minimal())
}
\description{
Highlights the cells belonging to any number of top clonotypes or of specifically selected clonotypes from one or more samples or groups in a GEX dimensional reduction.
}
\examples{

#To return a single plot with top clones across samples
overlay_clones_plot <- VDJ_GEX_overlay_clones(
GEX = Platypus::small_vgm[[2]], reduction = "umap"
,n.clones = 5, by.sample = FALSE
,by.other.group = "none", pt.size = 1,split.plot.and.legend = FALSE)

#To return a facet plot with top clones for each sample
overlay_clones_plot <- VDJ_GEX_overlay_clones(
GEX = Platypus::small_vgm[[2]], reduction = "umap"
,n.clones = 5, by.sample = TRUE, by.other.group = "none"
,pt.size = 1,ncol.facet = 2, split.plot.and.legend = FALSE)

#To return a facet plot and the legend separately with top clones for each group
overlay_clones_plot <- VDJ_GEX_overlay_clones(
GEX = Platypus::small_vgm[[2]], reduction = "umap"
,n.clones = 5, by.sample = TRUE, by.other.group = "group_id", pt.size = 1
,ncol.facet = 2, split.plot.and.legend = TRUE)

#To print both:
#overlay_clones_plot[[1]] #Plot
#gridExtra::grid.arrange(overlay_clones_plot[[2]]) #Legend
#To save, ggsave() is applicable to both

#To return a single plot with selected clones
#add a clonotype_to_plot column
#GEX@meta.data$clonotype_to_plot <- GEX$VJ_vgene == "TRAV5-1"
#Column with TRUE for all clones with a particular V gene
#overlay_clones_plot <- VDJ_GEX_overlay_clones(GEX = GEX, reduction = "umap"
#, clones.to.plot = "clonotype_to_plot", by.sample = TRUE, by.other.group = "none"
#, split.plot.and.legend = FALSE, pt.size = 1.5)

}
