% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{init.simulate.StateAndExp}
\alias{init.simulate.StateAndExp}
\title{Initialize state and expectation matrices}
\usage{
init.simulate.StateAndExp(phy, p, root.state, simulate_random)
}
\arguments{
\item{root.state}{(list): state of the root, with:
random : random state (TRUE) or deterministic state (FALSE)
value.root : if deterministic, value of the character at the root
exp.root : if random, expectation of the character at the root
var.root : if random, variance of the character at the root (pxp matrix)}

\item{phy:}{Input tree.}

\item{p:}{dimension of the trait simulated}
}
\value{
paramSimu: array p x Nnode x 2 (BM), filled with NAs.
Slice paramSimu[, ntaxa + 1, ] (array p x 2) is initialized with simulated states and root
expectations for all the traits.
}
\description{
Function used in \code{\link{simulate}} for BM/OU initializations.
}
\keyword{internal}
