% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_step.R
\name{compute_log_likelihood.simple}
\alias{compute_log_likelihood.simple}
\title{Log Likelihood}
\usage{
compute_log_likelihood.simple(phylo, Y_data_vec, sim, Sigma,
  Sigma_YY_chol_inv, miss = rep(FALSE, dim(sim)[1] *
  length(phylo$tip.label)), masque_data = c(rep(TRUE, dim(sim)[1] *
  length(phylo$tip.label)), rep(FALSE, dim(sim)[1] * phylo$Nnode)), ...)
}
\arguments{
\item{phylo}{Input tree.}

\item{sim}{(list) : result of function \code{simulate}}

\item{Sigma}{: variance-covariance matrix, result of function \code{compute_variance_covariance}}

\item{Y_data}{: vector indicating the data at the tips}

\item{Sigma_YY_inv}{: invert of the variance-covariance matrix of the data}
}
\value{
log likelihood of the data
}
\description{
\code{compute_log_likelihood.simple} computes the log-likelihood of the data 
in the simple case where the inverse of the variance matrix is given.
}
\details{
This function takes parameters sim, Sigma and Sigma_YY_inv from  
\code{compute_mean_variance.simple}. It uses functions 
\code{extract.variance_covariance}, \code{extract.covariance_parents}, and
 \code{extract_simulate_internal} to extract the needed quantities from these objects.
}
\keyword{internal}
