% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_EM.R
\name{find_independent_regression_vectors.glmnet_multivariate}
\alias{find_independent_regression_vectors.glmnet_multivariate}
\title{Given a regularization path, find K selected independant variables.}
\usage{
find_independent_regression_vectors.glmnet_multivariate(Xp, K, fit, root)
}
\arguments{
\item{Xp}{(transformed) matrix of regression}

\item{K}{number of non-zero components allowed}

\item{root}{integer, position of the root column (intercept) excluded from the fit. null 
if no root column.}
}
\value{
delta a vector of regression with K non-zero coefficients.
}
\description{
\code{find_independent_regression_vectors} tries to find a situation where K variables
are selected, so that the selected columns of matrix Xp are independant.
}
\details{
To do that, if a set of selected is not independent, we go back to the previous selected 
variables, and forbid the moves that led to non-independance for the rest of the path.
}
\keyword{internal}

