This shiny app presents the results from [PhenotypeR](https://ohdsi.github.io/PhenotypeR)  

The PhenotypeR package helps us to assess the research-readiness of a set of cohorts we have defined. This assessment includes:  

- ___Database diagnostics___ which help us to better understand the database in which they have been created. This includes information about the size of the data, the time period covered, the number of people in the data as a whole. More granular information that may influence analytic decisions, such as the number of observation periods per person, is also described.  
- ___Codelist diagnostics___ which help to answer questions like what concepts from our codelist are used in the database? What concepts were present led to individuals' entry in the cohort? Are there any concepts being used in the database that we didn't include in our codelist but maybe we should have?  
- ___Cohort diagnostics___ which help to answer questions like how many individuals did we include in our cohort and how many were excluded because of our inclusion criteria? If we have multiple cohorts, is there overlap between them and when do people enter one cohort relative to another? What is the incidence of cohort entry and what is the prevalence of the cohort in the database?  
- ___Matched diagnostics___ which compares our study cohorts to the overall population in the database. By matching people in the cohorts to people with a similar age and sex in the database we can see how our cohorts differ from the general database population.  
- ___Population diagnostics___ which estimates the frequency of our study cohorts in the database in terms of their incidence rates and prevalence.

<div style="display: flex; align-items: center; justify-content: flex-end; gap: 10px;">
    <a href="https://ohdsi.github.io/PhenotypeR" target="_blank">
        <img src="phenotyper_logo.png" alt="PhenotypeR Logo" style="width: 100px;">
    </a>
    <a href="https://ohdsi.org" target="_blank">
        <img src="ohdsi_logo.svg" alt="OHDSI Logo" style="width: 100px;">
    </a>
</div>

