% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_for_rev.R
\name{LP_for_rev_fit}
\alias{LP_for_rev_fit}
\title{Fit a combined FORWARD and REVERSE simple Lincoln-Petersen Model using pseudo-likelihood}
\usage{
LP_for_rev_fit(
  data,
  E,
  E.SE,
  G,
  G.SE,
  min.G = 0.01,
  n.boot = 100,
  trace = FALSE
)
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting.}

\item{E}{Escapement at one or more terminal areas. E, E.SE, G, G.SE must all have the same length}

\item{E.SE}{SE of the estimates of escapement}

\item{G}{Estimated proportion of the stock at the first capture location estimated using GSI and other methods}

\item{G.SE}{SE of the estimated stock proportion.}

\item{min.G}{Miniumum acceptable stock proportion during the bootstrap estimation of uncertainty}

\item{n.boot}{Number of bootstrap samples used to estimate the uncertainty}

\item{trace}{Should intermediate tracing be enabled (e.g. browser() stops)}
}
\value{
An list object of class \emph{LP_for_rev_est} with abundance estimates and measures of uncertainty
\itemize{
\item \strong{summary} A data frame with the pseudo-likelihood value, abundance estimates and SE
\item \strong{data} A data frame with the raw data used in the fit
\item \strong{fit} Results of the fit from the optimizer
\item \strong{datetime} Date and time the fit was done
}

Unlike other routine, it is not necessary to use a \emph{XX_est()} function to get estimates of abundance.
}
\description{
EXPERIMENTAL. This will take a data frame of capture histories, frequencies, and
additional covariates (e.g., strata and/or continuous covariates) for a simple forward Petersen
estimate plus estimates of escapement
and associated stock proportions with SE for backwards estimation.
DO NOT USE YET.
}
\details{
The frequency variable (\code{freq} in the \code{data} argument) is the number of animals with the corresponding capture history.

Capture histories (\code{cap_hist} in the \code{data} argument) are character values of length 2.
\itemize{
\item \strong{10}  Animals tagged but never seen again.
\item \strong{11}  Animals tagged and recaptured and tag present at event 2.
\item \strong{01}  Animals captured at event 2 that appear to be untagged.
}

A pseudo-likelihood is constructed consisting of the usual likelihood for a forward capture recapture and
marginal likelihoods for each of the escapement (E) and stock proportions (G) point estimates. I have not
integrated over the uncertainty in G and E.
}
\examples{
# Example of combined forward and reverse MR

# get some data
n1 <-  500
n2 <- 1500
m2 <-  150

f.data <- data.frame(cap_hist=c("10","11","01"), freq=c(n1 - m2,  m2,  n2 - m2))
f.data

E = 1500
E.SE = 150
G = .2
G.SE = .05

res <- LP_for_rev_fit(data=f.data,
                      E=E,
                      E.SE=E.SE,
                      G=G,
                      G.SE=G.SE)
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
